%define php_version %php_defver
%define system_requires apache2-base, apache2-mod_php%php_version, apache2-mod_ssl, mariadb-server
%define deploy_requires deploy >= 0.4.2
%define rule_requires   python3-module-pymysql, pwgen, curl

Name: installed-db-office-server
Version: 1.5.5
Release: alt1
Summary: Databases and config files for moodle, mediawiki and nextcloud
License: GPL-2.0+
Group: System/Configuration/Other
Source: %name-%version.tar
BuildArch: noarch

BuildRequires(pre): rpm-build-php
Requires: %name-mediawiki = %EVR
Requires: %name-nextcloud = %EVR
Requires: %name-moodle = %EVR

%description
Databases and config files for moodle, mediawiki and nextcloud

%package mediawiki
Summary: Databases and config files for mediawiki
Group: System/Configuration/Other
Requires: %system_requires
Requires: %deploy_requires
Requires: %rule_requires
Requires: mediawiki
Requires: mediawiki-apache2
Requires: mediawiki-mysql
Requires: python3-module-pymysql
Requires: pwgen
Requires: curl

%description mediawiki
Databases and config files for mediawiki

%package moodle
Summary: Databases and config files for moodle
Group: System/Configuration/Other
Requires: %system_requires
Requires: %deploy_requires
Requires: %rule_requires
Requires: moodle
Requires: moodle-apache2
Requires: moodle-base
Requires: moodle-local-mysql
Requires: python3-module-pymysql
Requires: pwgen
Requires: curl

%description moodle
Databases and config files for moodle

%package nextcloud
Summary: Databases and config files for nextcloud
Group: System/Configuration/Other
Requires: %system_requires
Requires: %deploy_requires
Requires: %rule_requires
Requires: nextcloud
Requires: nextcloud-apache2
Requires: php%php_version-pcntl
Requires: php%php_version-pdo_mysql
Requires: python3-module-pymysql
Requires: pwgen
Requires: curl
Provides: %name-owncloud = %EVR
Obsoletes: %name-owncloud < %EVR

%description nextcloud
Databases and config files for nextcloud

%prep
%setup

%build

%install
for service in mediawiki nextcloud moodle; do
    install -Dp -m755 $service %buildroot%_sysconfdir/firsttime.d/80-office-server-$service
    install -Dp -m755 ${service}-password %buildroot%_libexecdir/alterator/hooks/root.d/$service
done

%files

%files mediawiki
%_sysconfdir/firsttime.d/80-office-server-mediawiki
%_libexecdir/alterator/hooks/root.d/mediawiki

%files moodle
%_sysconfdir/firsttime.d/80-office-server-moodle
%_libexecdir/alterator/hooks/root.d/moodle

%files nextcloud
%_sysconfdir/firsttime.d/80-office-server-nextcloud
%_libexecdir/alterator/hooks/root.d/nextcloud

%changelog
