Name: ipcad
Version: 3.7.3
Release: alt5.1
Summary: IP accounting daemon
License: BSD-style
Group: Monitoring
Url: http://ipcad.sf.net
Packager: Denis Klimov <zver@altlinux.ru>
Source0: %name-%version.tar.gz
Source1: %name.init
Source2: %name.sysconfig
Source3: %name.conf
Patch: ipcad-3.7.3-alt-glibc-2.16.patch

BuildRequires: flex hostinfo iptables-devel libpcap-devel

%description
IPCAD stands for IP Cisco Accounting Daemon. It runs in background and
listens traffic on specified interfaces. ipcad uses raw BPF devices
(/dev/bpf*), PCAP library (pcap(3)), Linux iptables' ULOG (>=2.4.18-pre8)
and IPQ (libipq(3)), BSD divert(4) and tee packet sources.

IPCAD exports the collected information via rsh or NetFlow protocols.
Alternatively, a table can be dumped into the specified file, or printed
to the standard output or console

%prep
%setup
%patch -p2

%build
%autoreconf
%configure
%make_build

%install
%makeinstall
mkdir -p %buildroot%_initdir
mkdir -p %buildroot%_sbindir
mkdir -p %buildroot%_man8dir
mkdir -p %buildroot%_man5dir
mkdir -p %buildroot%_sysconfdir/sysconfig
mkdir -p %buildroot%_var/lib/%name

cp %buildroot%_bindir/%name %buildroot%_sbindir/%name 

install %SOURCE1 %buildroot%_initdir/%name
install ipcad.8 %buildroot%_man8dir
install ipcad.conf.5 %buildroot%_man5dir
install -pD -m644 %SOURCE2 %buildroot%_sysconfdir/sysconfig/%name
install -pD -m644 %SOURCE3 %buildroot%_sysconfdir/%name.conf

%files
%config %_initdir/*
%config(noreplace) %_sysconfdir/%name.conf
%config(noreplace) %_sysconfdir/sysconfig/*
%_sbindir/%name
%_mandir/man[58]/*
%dir %_var/lib/%name
%doc AUTHORS BUGS COPYING ChangeLog FAQ INSTALL README ipcad.conf.{default,simple}


%post
%post_service %name

%preun
%preun_service %name

%changelog
