%define _unpackaged_files_terminate_build 1

%define oname jgrapht

Name:    jgrapht
Epoch:   1
Version: 1.0.1
Release: alt1_jpp11
Summary: A free Java graph library that provides mathematical graph objs and algorithms
License: LGPLv2+
Group:   Development/Java
URL:     http://jgrapht.sourceforge.net/

BuildArch: noarch

# http://downloads.sourceforge.net/project/jgrapht/JGraphT/Version%%200.8.1/jgrapht-%{version}.tar.gz
Source: %oname-%version.tar

Patch1: %oname-%version-alt-build-core.patch

BuildRequires: rpm-build-java
BuildRequires: /proc
BuildRequires: jpackage-default
#BuildRequires: java-devel >= 1.6
BuildRequires: javapackages-local
BuildRequires: maven-local
BuildRequires: mvn(org.sonatype.oss:oss-parent:pom:)
BuildRequires: mvn(org.apache.felix:maven-bundle-plugin)

%description
JGraphT is a free Java graph library that provides mathematical graph-theory 
objects and algorithms.

%package javadoc
Group: Development/Java
Summary:        Javadocs for %{oname}
BuildArch: noarch

%description javadoc
This package contains the API documentation for %{oname}.

%prep
%setup -n %oname-%version
%patch1 -p2

%pom_remove_plugin :maven-shade-plugin jgrapht-demo/pom.xml
%pom_remove_plugin :maven-shade-plugin jgrapht-ext/pom.xml
%pom_remove_plugin :maven-shade-plugin jgrapht-touchgraph/pom.xml

%build
%mvn_build --skip-tests -- -Dmaven.compiler.source=1.8 -Dmaven.compiler.target=1.8 -Dmaven.javadoc.source=1.8 -Dmaven.compiler.release=8

%install
%mvn_install

%files -f .mfiles
%doc CONTRIBUTING.md CONTRIBUTORS.md HISTORY.md README.md
%doc license-EPL.txt license-LGPL.txt

%files javadoc -f .mfiles-javadoc
%doc CONTRIBUTING.md CONTRIBUTORS.md HISTORY.md README.md
%doc license-EPL.txt license-LGPL.txt

%changelog
