%define _unpackaged_files_terminate_build 1
%define java_home %_jvmdir/jre

%def_with check

%define nss_version 3.66
%define java_version 17

# jss was renamed dogtag-jss
%define jss_rebranded_version 5.2.0-alt1

Name: jss
Version: 5.4.2
Release: alt3

Summary: Java Security Services (JSS)
License: MPL-1.1 or GPLv2+ or LGPLv2+
Group: System/Libraries
Url: https://github.com/dogtagpki/jss
Vcs: https://github.com/dogtagpki/jss

Source0: %name-%version.tar
Source1: jss.watch
Patch: %name-%version-alt.patch

# - upstream doesn't support i586 (Fedora's Java 17 is not built for that arch)
# - ALT's Java 17 is not built for armh
ExcludeArch: %ix86 armh

BuildRequires(pre): rpm-macros-java
BuildRequires(pre): rpm-macros-cmake
BuildRequires: gcc-c++
BuildRequires: jaxb-api
BuildRequires: /proc
BuildRequires: cmake
BuildRequires: java-devel >= %java_version
BuildRequires: jpackage-generic-compat
BuildRequires: libnss-devel >= %nss_version
BuildRequires: libnspr-devel
BuildRequires: apache-commons-lang3
BuildRequires: slf4j
BuildRequires: slf4j-jdk14

# deps for tools/reproducible_jar.sh
BuildRequires: zip
BuildRequires: unzip

# not an optional though used only in tests
BuildRequires: junit

%if_with check
BuildRequires: ctest
BuildRequires: nss-utils >= %nss_version
%endif

%description
Java Security Services (JSS) is a java native interface which provides a bridge
for java-based applications to use native Network Security Services (NSS).
This only works with gcj. Other JREs require that JCE providers be signed.

%package -n dogtag-jss
Summary: Java Security Services (JSS)
Group: System/Libraries

Provides: jss = %EVR
Obsoletes: jss < %jss_rebranded_version

Requires: apache-commons-lang3
Requires: jaxb-api
Requires: slf4j
Requires: libnss >= %nss_version
Requires: java >= %java_version

%description -n dogtag-jss
Java Security Services (JSS) is a java native interface which provides a bridge
for java-based applications to use native Network Security Services (NSS).
This only works with gcj. Other JREs require that JCE providers be signed.

%prep
%setup
%patch -p1

%build
# Enable compiler optimizations and disable debugging code
# NOTE: If you ever need to create a debug build with optimizations disabled
# just comment out this line and change in the %%install section below the
# line that copies jars xpclass.jar to be xpclass_dbg.jar
export BUILD_OPT=1

%cmake \
    -DJAVA_HOME=%java_home \
    -DVERSION=%version \
    -DJNI_DIR=%_jnidir \
    -DLIB_DIR=%_libdir \
    -DWITH_JAVADOC=FALSE \
    ..

%cmake_build --target all

%check
# fails on migration to Java11, need to investigate
%ifnarch ppc64le
# FIPS is not enabled in kernel
cat > %_cmake__builddir/CTestCustom.cmake <<EOF
set(CTEST_CUSTOM_TESTS_IGNORE
   Enable_FipsMODE
   # NSS 3.81 failures
   # https://github.com/dogtagpki/jss/issues/882
   SSLClientAuth
   SSLEngine_RSA
   TestBufferPRFDSSL_RSA
   JSS_Test_BufferPRFD
   SSLClientAuth_FIPSMODE
   SSLEngine_RSA_FIPSMODE
)
EOF
CTEST_OUTPUT_ON_FAILURE=1 %cmake_build --target test
%endif

%install
%cmake_install

%files -n dogtag-jss
%dir %_libdir/jss
%_libdir/jss/jss.jar
%_libdir/jss/libjss.so
%_libdir/jss/libjss-symkey.so
%_jnidir/jss.jar

%changelog
