%define _unpackaged_files_terminate_build 1

Name: kernel-build-tools
Version: 0.129
Release: alt1

Summary: Utilities to build kernel packages for ALT Linux
License: GPL-2.0-or-later
Group: Development/Kernel
Packager: Kernel Maintainers Team <kernel@packages.altlinux.org>

Source: %name-%version.tar

Requires: describe-specfile
Requires: rpm-build-kernel = %EVR
Requires: rpm-utils

# due to RPM macro expansion support
Requires: gear >= 1.3.1

BuildRequires: help2man
%{?!_without_check:%{?!_disable_check:
BuildRequires: describe-specfile
BuildRequires: faketime
BuildRequires: rpm-utils
BuildRequires: shellcheck
}}

%package -n rpm-build-kernel
Summary: RPM macros to build kernel packages
Group: Development/Kernel
Conflicts: rpm-build < 4.0.4-alt1

# ExclusiveArch / ExcludeArch are evaluated after BuildRequires(pre) is
# satisfied, but kernel-modules-s have kernel-headers-modules-@kflavour@
# there causing unmet. As a workaround hack this package creates fake
# provides on the _excluded_ arches.
%ifnarch x86_64 aarch64
Provides: kernel-headers-modules-centos
Provides: kernel-headers-modules-rt
Provides: kernel-headers-modules-talos
%endif
%ifnarch x86_64
Provides: kernel-headers-modules-ovz-el7
%endif
%ifnarch %ix86
Provides: kernel-headers-modules-std-pae
%endif
%ifnarch aarch64
Provides: kernel-headers-modules-mp
Provides: kernel-headers-modules-rk
%endif
%ifnarch %e2k
Provides: kernel-headers-modules-elbrus-def
%endif
%ifnarch e2k
Provides: kernel-headers-modules-elbrus-4c
%endif
%ifnarch e2kv4
Provides: kernel-headers-modules-elbrus-1cp
Provides: kernel-headers-modules-elbrus-8c
%endif

%description
Utilities to facilitate creation of kernel and additional module packages
according to ALT Linux kernel packaging conventions.

%description -n rpm-build-kernel
RPM macros used to build kernel packages according to ALT Linux
kernel packaging conventions.

%prep
%setup

%build
%make_build

%install
%makeinstall_std

%check
%ifarch i586 armh loongarch64
# FAKETIME does not work on armh and i586
# FAKETITME fails to build on LoongArch
%make_build shellcheck
%else
%make_build check
%endif

%files
%_bindir/*
%_mandir/man?/*
%doc config.sh.sample

%files -n rpm-build-kernel
%_rpmmacrosdir/kernel
%_rpmlibdir/query-kEVR.sh
%_rpmlibdir/kernel.req*

%changelog
