%define rname kimageformats

Name: kf6-%rname
Version: 6.16.0
Release: alt1
%K6init altplace

Group: System/Libraries
Summary: KDE Frameworks 6 plugins to allow QImage to support extra file formats
Url: http://www.kde.org
License: LGPL-2.1-or-later

Requires: %name-common >= %EVR

Source: %rname-%version.tar

BuildRequires(pre): rpm-build-kf6
BuildRequires: extra-cmake-modules qt6-tools-devel
BuildRequires: zlib-devel
BuildRequires: openexr-devel
BuildRequires: libavif-devel
BuildRequires: libraw-devel
BuildRequires: libheif-devel
BuildRequires: libjasper-devel
BuildRequires: libopenjpeg2.0-devel openjpeg-tools2.0
%ifnarch %arm
BuildRequires: libjxl-devel
%endif
# JXR disabled by default
#BuildRequires: libjxr-devel
BuildRequires: kf6-karchive-devel

%description
This framework provides additional image format plugins for QtGui.  As
such it is not required for the compilation of any other software, but
may be a runtime requirement for Qt-based software to support certain
image formats.

%package common
Summary: %name common package
Group: System/Configuration/Other
BuildArch: noarch
Requires: kde-common
%description common
%name common package

%package devel
Group: Development/KDE and QT
Summary: Development files for %name
Requires: %name-common >= %EVR
%description devel
The %name-devel package contains libraries and header files for
developing applications that use %name.

%prep
%setup -n %rname-%version

%build
%K6build \
    -DKIMAGEFORMATS_HEIF=ON \
    #

%install
%K6install
%find_lang %name --all-name
%K6find_qtlang %name --all-name

%files common
%doc LICENSES/* README.md

%files
%_K6plug/imageformats/kimg_*.so
#%_K6srv/qimageioplugins/

%files devel
%_libdir/cmake/KF6ImageFormats/

%changelog
