%define rname kig
%add_python3_path %_K5bin
%add_findreq_skiplist %_K5bin/pykig.py
%define add_python3_requires() %(echo -n "Requires: "; for p in %*; do echo -n "python3($p) "; done; echo)

Name: %rname
Version: 24.12.2
Release: alt1
%K5init

Group: Education
Summary: Interactive Geometry
Url: http://www.kde.org
License: GPL-2.0-or-later and LGPL-2.1-or-later

%add_python3_requires traceback os math getopt xml.sax.saxutils
Provides:  kde5-kig = %EVR
Obsoletes: kde5-kig < %EVR

Source: %rname-%version.tar
# upstream
Patch1: 0001-explicitly-use-QLibrary-to-load-libpython-like-pykde.patch

BuildRequires(pre): rpm-build-kf5 rpm-build-python3
BuildRequires: extra-cmake-modules qt5-declarative-devel qt5-svg-devel qt5-xmlpatterns-devel
BuildRequires: boost-devel-headers boost-python3-devel
BuildRequires: kf5-karchive-devel kf5-kauth-devel kf5-kbookmarks-devel kf5-kcodecs-devel kf5-kcompletion-devel
BuildRequires: kf5-kconfig-devel kf5-kconfigwidgets-devel kf5-kcoreaddons-devel kf5-kdelibs4support kf5-kdoctools-devel
BuildRequires: kf5-kemoticons-devel kf5-ki18n-devel kf5-kiconthemes-devel kf5-kio-devel kf5-kitemmodels-devel kf5-kitemviews-devel
BuildRequires: kf5-kjobwidgets-devel kf5-kparts-devel kf5-kservice-devel kf5-ktexteditor-devel kf5-ktextwidgets-devel kf5-kwidgetsaddons-devel
BuildRequires: kf5-kxmlgui-devel kf5-solid-devel kf5-sonnet-devel kf5-kcrash-devel kf5-syntax-highlighting-devel

%description
Kig is a program for exploring geometric constructions.


%prep
%setup -n %rname-%version
%patch1 -p1
sed -i '1d' pykig/pykig.py
sed -i '1i#!%__python3' pykig/pykig.py
#sed -i -E '/[[:space:]]except[[:space:]]+.*,.*/s/(^.*except[[:space:]]+)([[:alpha:]].*):$/\1(\2):/' pykig/pykig.py

%build
PY3_VER_WO_DOTS=`echo "%_python3_abi_version"| sed 's|\.||g'`
%K5build \
    -DPYTHON_EXECUTABLE:PATH=%__python3 \
    -DPYTHON_INCLUDE_DIR=%__python3_includedir \
    -DPYTHON_LIBRARY=%__libpython3 \
    -DBoostPython_INCLUDE_DIRS="%__python3_includedir;%_includedir/boost" \
    -DBoostPython_LIBRARIES="%__libpython3;%_libdir/libboost_python${PY3_VER_WO_DOTS}.so" \
    #

%install
%K5install
%K5install_move data kig katepart
%find_lang %name --with-kde --all-name

%files -f %name.lang
%doc LICENSES/*
%_K5bin/kig
%_K5bin/pykig.py
%_K5plug/kf5/parts/*kig*.so
%_K5data/kig/
%_datadir/katepart5/syntax/*-kig.xml
%_K5icon/*/*/apps/kig.*
%_K5icon/*/*/mimetypes/application-x-kig.*
%_K5xdgapp/org.kde.kig.desktop
%_datadir/metainfo/*.xml

%changelog
