%define _unpackaged_files_terminate_build 1

%define _localstatedir  %_var

# ldapjdk was renamed dogtag-ldapjdk
%define ldapjdk_rebranded_version 5.2.0-alt1

%define jss_version 5.2.0
%define java_version 17

Name: ldapjdk
Epoch: 1
Version: 5.4.1
Release: alt1

Summary: LDAP SDK
License: MPL-1.1 or GPLv2+ or LGPLv2+
Group: Development/Java
Url: https://github.com/dogtagpki/ldap-sdk
Vcs: https://github.com/dogtagpki/ldap-sdk
Source: %name-%version.tar
Patch: %name-%version-alt.patch

# - upstream doesn't support i586 (Fedora's Java 17 is not built for that arch)
# - ALT's Java 17 is not built for armh
ExcludeArch: %ix86 armh

BuildRequires(pre): rpm-macros-java
BuildRequires: rpm-build-java

BuildRequires: /proc
BuildRequires: ant
BuildRequires: java-devel >= %java_version
BuildRequires: javapackages-local
BuildRequires: javapackages-tools
BuildRequires: dogtag-jss >= %jss_version

%description
The Mozilla LDAP SDKs enable you to write applications which access,
manage, and update the information stored in an LDAP directory.

################################################################################
%package -n dogtag-ldapjdk
Summary: LDAP SDK
Group: System/Libraries

Provides: ldapjdk = %EVR
Obsoletes: ldapjdk < %ldapjdk_rebranded_version
Provides: ldapsdk = 1:%version-%release
Obsoletes: ldapsdk <= 1:4.18-alt1_2jpp6

Requires: dogtag-jss >= %jss_version
Requires: java >= %java_version

%description -n dogtag-ldapjdk
The Mozilla LDAP SDKs enable you to write applications which access,
manage, and update the information stored in an LDAP directory.

################################################################################
%package -n dogtag-ldapjdk-javadoc
Group: Development/Documentation

Summary: Javadoc for dogtag-ldapjdk
BuildArch: noarch

Provides: ldapjdk-javadoc = %EVR
Obsoletes: ldapjdk-javadoc < %ldapjdk_rebranded_version

%description -n dogtag-ldapjdk-javadoc
Javadoc for dogtag-ldapjdk

################################################################################
%prep
################################################################################

%setup
%patch -p1

################################################################################
%build
################################################################################

cd java-sdk
%ant -v dist

################################################################################
%install
################################################################################

install -d -m 755 %buildroot%_javadir
install -m 644 java-sdk/dist/packages/%name.jar %buildroot%_javadir/%name.jar
install -m 644 java-sdk/dist/packages/ldapsp.jar %buildroot%_javadir/ldapsp.jar
install -m 644 java-sdk/dist/packages/ldapfilt.jar %buildroot%_javadir/ldapfilt.jar
install -m 644 java-sdk/dist/packages/ldapbeans.jar %buildroot%_javadir/ldapbeans.jar
install -m 644 java-sdk/dist/packages/ldaptools.jar %buildroot%_javadir/ldaptools.jar

mkdir -p %buildroot%_mavenpomdir
install -pm 644 java-sdk/ldapjdk/pom.xml %buildroot%_mavenpomdir/JPP-ldapjdk.pom
install -pm 644 java-sdk/ldapfilter/pom.xml %buildroot%_mavenpomdir/JPP-ldapfilter.pom
install -pm 644 java-sdk/ldapbeans/pom.xml %buildroot%_mavenpomdir/JPP-ldapbeans.pom
install -pm 644 java-sdk/ldapsp/pom.xml %buildroot%_mavenpomdir/JPP-ldapsp.pom
install -pm 644 java-sdk/ldaptools/pom.xml %buildroot%_mavenpomdir/JPP-ldaptools.pom

install -d -m 755 %buildroot%_javadocdir/%name
cp -r java-sdk/dist/doc/* %buildroot%_javadocdir/%name
ln -s ldapjdk.jar %buildroot%_javadir/ldapsdk.jar

################################################################################
%files -n dogtag-ldapjdk
%_javadir/%name.jar
%_javadir/ldapsp.jar
%_javadir/ldapfilt.jar
%_javadir/ldapbeans.jar
%_javadir/ldapsdk.jar
%_javadir/ldaptools.jar
%_mavenpomdir/JPP-ldapjdk.pom
%_mavenpomdir/JPP-ldapsp.pom
%_mavenpomdir/JPP-ldapfilter.pom
%_mavenpomdir/JPP-ldapbeans.pom
%_mavenpomdir/JPP-ldaptools.pom

################################################################################
%files -n dogtag-ldapjdk-javadoc
%dir %_javadocdir/%name
%_javadocdir/%name/*

################################################################################
%changelog
