%define optflags_lto %nil

Name: libOSMesa
Version: 25.0.7
Release: alt2
Epoch: 4
License: MIT
Summary: Mesa offscreen rendering libraries
Group: System/Libraries
Url: https://www.mesa3d.org

Source: %name-%version.tar
Patch: %name-%version.patch

#BuildPreReq: /proc
BuildRequires(pre): rpm-macros-meson
BuildRequires: meson
BuildRequires: gcc-c++
BuildRequires: pkgconfig(expat)
BuildRequires: pkgconfig(zlib) >= 1.2.3
BuildRequires: pkgconfig(libzstd)
#BuildRequires: bison
BuildRequires: flex
BuildRequires: pkgconfig(libelf)
BuildRequires: llvm-devel >= 7.0.0
BuildRequires: libdrm-devel
BuildRequires: python3-devel
BuildRequires: python3-module-mako
BuildRequires: python3-module-pycparser
BuildRequires: python3-module-yaml

%description
%summary.

%package -n libOSMesa-devel
Summary: Mesa offscreen rendering development package
Group: Development/C

%description -n libOSMesa-devel
%summary.

%set_verify_elf_method unresolved=relaxed

%prep
%setup -q
%patch -p1

tar -xf subprojects.tar

%build
%meson \
  -Dplatforms= \
  -Dosmesa=true \
  -Dgallium-drivers=llvmpipe \
  -Dgallium-vdpau=disabled \
  -Dgallium-va=disabled \
  -Dgallium-xa=disabled \
  -Dgallium-nine=false \
  -Dgallium-opencl=disabled \
  -Dgallium-rusticl=false \
  -Dvulkan-drivers= \
  -Dshared-glapi=enabled \
  -Dgles1=disabled \
  -Dgles2=disabled \
  -Dopengl=true \
  -Dgbm=disabled \
  -Dglvnd=disabled \
  -Dglx=disabled \
  -Degl=disabled \
  -Dllvm=enabled \
  -Dshared-llvm=enabled \
  -Dvalgrind=disabled \
  -Dbuild-tests=false \
  -Dmesa-clc=auto \
  -Dmicrosoft-clc=disabled \
  -Dxlib-lease=disabled \
  -Dandroid-libbacktrace=disabled \
  -Dlibunwind=disabled \
  -Dlmsensors=disabled \
%ifarch %{ix86}
  -Dglx-read-only-text=true \
%endif
  %{nil}

%meson_build

%install
%meson_install

# trim some garbage, the mesa base package handles these
rm -rf %buildroot%_datadir/drirc.d
rm -rf %buildroot%_includedir/GL/gl*.h
rm -rf %buildroot%_includedir/KHR

%files -n libOSMesa
%_libdir/libOSMesa.so.*

%files -n libOSMesa-devel
%_includedir/GL/osmesa.h
%_libdir/libOSMesa.so
%_pkgconfigdir/osmesa.pc

%changelog
