%define origname adplug
%define dbver 1.0

Name: lib%origname
Version: 2.3.3
Release: alt1.git104.g66b19f6

Summary: AdLib sound player library
License: LGPL
Group: System/Libraries

Url: http://adplug.github.io/
#https://github.com/adplug/adplug/archive/adplug-2.3.tar.gz
Source: %origname-%version.tar
#https://github.com/adplug/database/archive/v1.0.tar.gz
Source1: adplugdb-%dbver.tar
Source44: %origname.watch
Source45: %origname-database.watch

# Automatically added by buildreq on Sun Sep 09 2012 (-bi)
# optimized out: elfutils gnu-config libstdc++-devel pkg-config python-base
BuildRequires: chrpath gcc-c++ libbinio-devel texinfo

%if_enabled static
BuildPreReq: glibc-devel-static
%endif

%description
AdPlug is a free, multi-platform, hardware independent AdLib sound player
library, mainly written in C++. AdPlug plays sound data, originally created
for the AdLib (OPL2) audio board, on top of an OPL2 emulator or by using the
real hardware. No OPL2 chip is required for playback.

It supports various audio formats from MS-DOS AdLib trackers.

%package devel
Group: Development/C++
Summary: Development files of AdPlug
Requires: %name = %version-%release

%description devel
AdPlug is a free, multi-platform, hardware independent AdLib sound player
library, mainly written in C++. AdPlug plays sound data, originally created
for the AdLib (OPL2) audio board, on top of an OPL2 emulator or by using the
real hardware. No OPL2 chip is required for playback.

It supports various audio formats from MS-DOS AdLib trackers.

This package contains the C++ headers and documentation required for
building programs based on AdPlug.

%if_enabled static
%package devel-static
Group: Development/C++
Summary: Static library of AdPlug
Requires: %name-devel = %version-%release

%description devel-static
AdPlug is a free, multi-platform, hardware independent AdLib sound player
library, mainly written in C++. AdPlug plays sound data, originally created
for the AdLib (OPL2) audio board, on top of an OPL2 emulator or by using the
real hardware. No OPL2 chip is required for playback.

It supports various audio formats from MS-DOS AdLib trackers.

This package contains the static library required for statically
linking applications based on AdPlug.

%endif #enabled static

%prep
%setup -n %origname-%version
tar xf %SOURCE1

%build
%add_optflags -fsigned-char
%autoreconf -Im4
%configure --sharedstatedir=%_datadir
%make_build

%install
%makeinstall
chrpath -d %buildroot%_bindir/adplugdb

mkdir -p %buildroot%_datadir
cp -a adplugdb-%dbver %buildroot%_datadir/%origname
rpm -q glibc-devel-static || rm -f %buildroot%_libdir/*.a

%files
%doc AUTHORS BUGS COPYING ChangeLog NEWS README TODO
%_bindir/adplugdb
%_man1dir/adplugdb.1*
%_libdir/*.so.*
%_datadir/%origname

%files devel
%_includedir/%origname
%_libdir/*.so
%_pkgconfigdir/%origname.pc
%_infodir/%name.*

%if_enabled static
%files devel-static
%_libdir/*.a
%endif

%changelog
