%define origname aubio
%define sover 5
%def_enable python

Name: libaubio%sover
Version: 0.4.9
Release: alt8
Summary: Aubio is a library for real time audio labelling
Url: http://www.aubio.org/
VCS: https://github.com/aubio/aubio
License: GPLv3
Group: System/Libraries

Source: %origname-%version.tar
Patch0: %name-%version-alt.patch

# Automatically added by buildreq on Thu Nov 06 2008
BuildRequires: docbook-to-man jackit-devel libfftw3-devel libsamplerate-devel libsndfile-devel

BuildPreReq: python3-base waf >= 1.9.12
BuildPreReq: txt2man doxygen python3-dev libswresample-devel
BuildPreReq: libnumpy-py3-devel python3-module-numpy

%description
Aubio is a library for real time audio labelling. Its features include
segmenting a sound file before each of its attacks, performing pitch detection,
tapping the beat and producing midi streams from live audio.

A few examples of applications are provided in examples/ and python/:
 - aubioonset output the onset detected,
 - aubionotes emits midi-like notes,
 - aubiocut is a python script that takes an input sound and creates one new
   sample at each detected onset or beat,
 - aubiopitch is a python script to extract pitch tracks from sound files.

%if_enabled python
%package -n python3-module-%origname
Group: Development/Python
Summary: Python bindings to %name
Requires: %name = %EVR

%description -n python3-module-%origname
Aubio is a library for real time audio labelling. Its features include
segmenting a sound file before each of its attacks, performing pitch detection,
tapping the beat and producing midi streams from live audio.

This package contains the Python bindings required for
building Python programs based on %name.
%endif

%package devel
Group: Development/C
Summary: Development files of %name
Requires: %name = %EVR
Conflicts: lib%origname-devel
Provides: lib%origname-devel

%description devel
Aubio is a library for real time audio labelling. Its features include
segmenting a sound file before each of its attacks, performing pitch detection,
tapping the beat and producing midi streams from live audio.

This package contains the C headers and documentation required for
building programs based on %name.

%package examples
Group: Sound
Summary: Examples of %name
Conflicts: lib%origname-examples

%description examples
Aubio is a library for real time audio labelling. Its features include
segmenting a sound file before each of its attacks, performing pitch detection,
tapping the beat and producing midi streams from live audio.

This package contains
A few examples of applications are provided in examples/ and python/:
 - aubioonset output the onset detected,
 - aubionotes emits midi-like notes,
 - aubiocut is a python script that takes an input sound and creates one new
   sample at each detected onset or beat,
 - aubiopitch is a python script to extract pitch tracks from sound files.

aubioonset and aubionotes can work either off-line or online, outputting the
results on the console or playing a wood-block sound at each detected onset.
Both Python scripts can plot the results with Gnuplot.

%package devel-docs
Summary: Documentation for %name
Group: Development/Documentation
BuildArch: noarch

%description devel-docs
Aubio is a library for real time audio labelling. Its features include
segmenting a sound file before each of its attacks, performing pitch detection,
tapping the beat and producing midi streams from live audio.

This package contains documentation for %name.

%prep
%setup -n %origname-%version
%patch0 -p1

rm -fR waflib

%build
waf configure --prefix=%prefix \
	     --libdir=%_libdir \
	     --disable-avcodec \
	     %nil
waf build -vv

%if_enabled python
%python3_build
%endif

%install
waf install --destdir=%buildroot
rm -v %buildroot%_libdir/libaubio.a

%if_enabled python
%python3_install
%endif

%files
%doc AUTHORS ChangeLog README.md doc/*
%_libdir/*.so.%{sover}*

%if_enabled python
%files -n python3-module-%origname
%doc python/README.md python/demos
%python3_sitelibdir/*
%endif

%files devel
%_includedir/%origname
%_libdir/*.so
%_pkgconfigdir/%origname.pc

%files examples
%_bindir/*
#_datadir/sounds/%origname
%_man1dir/*

%files devel-docs
%_docdir/lib%origname-doc

%changelog
