%def_disable snapshot

%define _name cairomm
%define ver_major 1.14
%define api_ver 1.0

%def_disable docs
# boost.pc required
%def_disable check

Name: lib%_name
Version: %ver_major.5
Release: alt1

Summary: This library provides a C++ interface to cairo
License: LGPL-2.0
Group: System/Libraries
Url: https://cairographics.org/cairomm

%if_disabled snapshot
Source: https://www.cairographics.org/releases/%_name-%version.tar.xz
%else
Vcs: https://git.cairographics.org/git/cairomm
Source: %_name-%version.tar
%endif

%define cairo_ver 1.12
%define sigc_ver 2.6.0

BuildRequires(pre): rpm-macros-meson
BuildRequires: meson gcc-c++ mm-common
BuildRequires: libcairo-devel >= %cairo_ver libsigc++2-devel >= %sigc_ver
%{?_enable_docs:BuildRequires: docbook-style-xsl doxygen graphviz xsltproc}
%{?_enable_check:BuildRequires: boost-test-devel fontconfig-devel}

%description
This library provides a C++ interface to cairo.

%package devel
Summary: Headers and development files of %name library
Group: Development/GNOME and GTK+
Requires: %name = %EVR

%description devel
This package contains the headers and various development files needed
for compiling or development of applications that wants C++ interface
of %name library.

%package devel-doc
Summary: Development documentation for %name
Group: Development/Documentation
BuildArch: noarch
Conflicts: %name < %version

%description devel-doc
This package contains documentation needed for developing %_name applications.

%prep
%setup -n %_name-%version

%build
%{?_enable_snapshot:mm-common-prepare -f}
%meson \
    %{?_enable_docs:-Dbuild-documentation=true} \
    %{?_enable_snapshot:-Dmaintainer-mode=true
    -Dbuild-documentation=true} \
    %{?_enable_check:-Dbuild-tests=true
    -Dboost-shared=true}
%nil
%meson_build

%install
%meson_install

%check
%__meson_test

%files
%doc NEWS
%_libdir/*.so.*

%files devel
%_includedir/cairomm-%api_ver
%_libdir/cairomm-%api_ver
%_libdir/*.so
%_pkgconfigdir/*.pc

%if_enabled docs
%files devel-doc
%_datadir/devhelp/books/%_name-%api_ver/
%_datadir/doc/%_name-%api_ver/
%endif

%changelog
