# Unpackaged files in buildroot should terminate build
%define _unpackaged_files_terminate_build 1

Name: libcpuid
Version: 0.7.1
Release: alt1
Summary: libcpuid provides CPU identification for the x86 (and x86_64)
License: BSD-2-Clause
Group: Development/C
Url: https://github.com/anrieff/libcpuid
Source: libcpuid-%version.tar
Patch: %name-%version-%release.patch

ExclusiveArch: %ix86 x86_64

BuildRequires(pre): rpm-build-kernel
BuildRequires(pre): rpm-macros-cmake
BuildRequires: cmake gcc-c++
BuildRequires: doxygen graphviz

%description
%summary.

%package devel
Summary: Development files for %name
Group: Development/C++
Requires: %name = %EVR

%description devel
The %name-devel package contains libraries and header files for
developing applications that use %name.
For details about the programming API, please see the docs
on the project's site (http://libcpuid.sourceforge.net/)

%package -n kernel-source-cpuid
Summary: cpuid kernel driver for arm64
Group: Development/Kernel

%description -n kernel-source-cpuid
cpuid kernel driver for arm64.

%prep
%setup
%autopatch -p1

%build
%cmake -DCMAKE_INSTALL_LIBDIR=%_libdir
%cmake_build

%install
%cmake_install

#%%ifarch aarch64
#mkdir -p %kernel_srcdir
#cd %buildroot%prefix/src/
#mv cpuid-%version kernel-source-cpuid-%version
#tar -cjvf %kernel_srcdir/kernel-source-cpuid-%version.tar.bz2 kernel-source-cpuid-%version
#rm -r kernel-source-cpuid-%version
#%%endif

%files
%_libdir/%name.so.*

%files devel
%_bindir/cpuid_tool
%_includedir/%name
%_man3dir/*
%_libdir/%name.so
%_libdir/pkgconfig/%name.pc
%_prefix/lib/cmake/cpuid

#%%ifarch aarch64
#%%files -n kernel-source-cpuid
#%%attr(0644,root,root) %kernel_src/kernel-source-cpuid-%version.tar.bz2
#%%endif

%changelog
