%def_without check

Name: libdispatch
Version: 5.9
Release: alt1

Summary: Apple's Grand Central Dispatch library

License: ASL 2.0
Group: Development/C
Url: https://github.com/apple/swift-corelibs-libdispatch

Packager: Vitaly Lipatov <lav@altlinux.ru>

%define reltag %version-RELEASE

# Source-url: https://github.com/apple/swift-corelibs-libdispatch/archive/swift-%reltag.tar.gz
Source: %name-%version.tar

Patch0: noerrors.patch

BuildRequires: llvm

BuildRequires: clang libstdc++-devel
BuildRequires: libbsd-devel
BuildRequires: ninja-build
BuildRequires: cmake
BuildRequires: chrpath

%if_with check
BuildRequires: ctest
%endif

ExcludeArch: ppc64le

Provides:      libBlocksRuntime = %EVR
Obsoletes:     libBlocksRuntime < 7.0.0

# due Block.h
Conflicts: libgnustep-objc2-devel < 2.1-alt3

%ifarch armh
%define optflags_lto %nil
%endif

%description
Grand Central Dispatch (GCD or libdispatch) provides
comprehensive support for concurrent code execution on
multicore hardware.

libdispatch is currently available on all Darwin platforms.
This project aims to make a modern version of libdispatch
available on all other Swift platforms. To do this, we will
implement as much of the portable subset of the API as
possible, using the existing open source C implementation.

libdispatch on Darwin is a combination of logic in the xnu
kernel alongside the user-space Library. The kernel has the
most information available to balance workload across the
entire system. As a first step, however, we believe it is
useful to bring up the basic functionality of the library
using user-space pthread primitives on Linux. Eventually, a
Linux kernel module could be developed to support more
informed thread scheduling.

%package devel
Summary: Development files for %name
Requires: %name = %EVR
Group: Development/C
Provides: libBlocksRuntime-devel = %EVR
Obsoletes: libBlocksRuntime-devel < 7.0.0

%description devel
Development files for %name.

%prep
%setup
%patch0 -p0

%build
export CXX=clang++
export CC=clang
%cmake -G Ninja
%cmake_build

%install
%cmake_install
chrpath --delete %buildroot%_libdir/libdispatch.so

%check
%cmake_build --target test

%files
%doc LICENSE
%_libdir/libBlocksRuntime.so
%_libdir/libdispatch.so
%_man3dir/*

%files devel
%_includedir/Block.h
%_includedir/dispatch/
%_includedir/os/

%changelog
