Name: libdwarf
Version: 20200114
Release: alt2

Summary: Library to access the DWARF Debugging file format

Group: Development/C
License: LGPLv2
Url: http://www.prevanders.net/dwarf.html

BuildPreReq: gcc-c++ binutils-devel libelf-devel

%define soversion 0
%define soname libdwarf.so.%soversion
%define sofullname libdwarf.so.%soversion.%version.0

Packager: Vitaly Lipatov <lav@altlinux.ru>

Source: http://www.prevanders.net/%name-%version.tar.gz

%package devel
Summary: Library and header files of libdwarf
Group: Development/C
License: LGPLv2
Requires: %name = %version-%release

%package devel-static
Summary: Static libdwarf library
Group: Development/C
License: LGPLv2
Requires: %name-devel-static = %version-%release

%package tools
Summary: Tools for accessing DWARF debugging information
Group: Development/Tools
License: GPLv2
Requires: %name = %version-%release

%description
Library to access the DWARF debugging file format which supports
source level debugging of a number of procedural languages, such as C, C++,
and Fortran.  Please see http://www.dwarfstd.org for DWARF specification.

%description devel-static
Static libdwarf library.

%description devel
Development package containing library and header files of libdwarf.

%description tools
C++ version of dwarfdump (dwarfdump2) command-line utilities
to access DWARF debug information.

%prep
%setup -n dwarf-%version
# hack
%__subst "s|@dwfzlib@|@dwfzlib@ -lelf|" libdwarf/Makefile.in

%build
%autoreconf
%configure --enable-shared --disable-static
%make_build

%install
%makeinstall_std
rm -rfv %buildroot%_datadir/libdwarf/libdwarf-devel/
mkdir -p %buildroot%_includedir/%name/
mv %buildroot%_includedir/*.h %buildroot%_includedir/%name/

%files
%doc libdwarf/ChangeLog libdwarf/README libdwarf/COPYING libdwarf/LIBDWARFCOPYRIGHT libdwarf/LGPL.txt
%_libdir/libdwarf.so.*

#files devel-static
#{_libdir}/libdwarf.a

%files devel
%doc libdwarf/*.pdf
%_includedir/%name/libdwarf.h
%_includedir/%name/dwarf.h
%_libdir/libdwarf.so

%files tools
%doc dwarfdump/README dwarfdump/ChangeLog dwarfdump/COPYING dwarfdump/DWARFDUMPCOPYRIGHT dwarfdump/GPL.txt
%_bindir/dwarfdump
%_man1dir/*
%_datadir/dwarfdump/

%changelog
