%def_disable snapshot

%define api_ver 1.0
%def_disable doc
%def_enable check

Name: libevdev
Version: 1.13.4
Release: alt1

Summary: kernel evdev device wrapper library
Group: System/Libraries
License: MIT and GPL-2.0
Url: https://www.freedesktop.org/wiki/Software/libevdev

Vcs: https://gitlab.freedesktop.org/libevdev/libevdev.git

%if_disabled snapshot
Source: https://www.freedesktop.org/software/%name/%name-%version.tar.xz
%else
Source: %name-%version.tar
%endif

BuildRequires(pre): rpm-macros-meson rpm-macros-valgrind
BuildRequires: meson glibc-kernheaders libcheck-devel python3-module-setuptools
%{?_enable_doc:BuildRequires: doxygen}
%ifarch %valgrind_arches
BuildRequires: valgrind
%endif

%description
%name is a wrapper library for evdev devices.

%package devel
Summary: kernel evdev device wrapper library development package
Group: Development/C
Requires: %name = %EVR

%description devel
This package contains development libraries and header files
that are needed to write applications that use %name.

%prep
%setup

%build
%meson \
    %{?_disable_doc:-Ddocumentation=disabled} \
    %{?_disable_check:-Dtests=disabled}
%nil
%meson_build

%install
%meson_install

%check
%__meson_test

%files
%_bindir/mouse-dpi-tool
%_bindir/touchpad-edge-detector
%_bindir/libevdev-tweak-device
%_libdir/libevdev.so.*
%_man1dir/libevdev-tweak-device.1.*
%_man1dir/touchpad-edge-detector.1.*
%_man1dir/mouse-dpi-tool.1.*
%doc README* COPYING

%files devel
%_includedir/%name-%api_ver/
%_libdir/%name.so
%_pkgconfigdir/%name.pc
%_man3dir/%name.3.*

%changelog
