Name: libevent
Version: 2.1.12
Release: alt1

Summary: Abstract asynchronous event notification library
# arc4random.c is ISC, the rest is BSD-3-Clause.
License: BSD-3-Clause and ISC
Group: System/Libraries
Url: https://libevent.org/

%define libname %{name}2.1
%def_disable static

# https://github.com/libevent/libevent/releases/download/release-%version-stable/libevent-%version-stable.tar.gz
Source: %name-%version.tar
Source1: libevent.so
Source2: Makefile.sample
# git://git.altlinux.org/gears/l/%name.git
Patch: %name-%version-%release.patch

# For event_rpcgen.py
BuildRequires(pre): rpm-build-python3

BuildRequires: libssl-devel zlib-devel

%package -n %libname
Summary: Abstract asynchronous event notification library
Group: System/Libraries
Provides: %name = %EVR

%package devel
Summary: Development libevent library, its header files and documentation
Group: Development/C

%package devel-static
Summary: Static libevent library
Group: Development/C
Requires: %name-devel

%description
The libevent API provides a mechanism to execute a callback function
when a specific event occurs on a file descriptor or after a timeout
has been reached.

libevent is meant to replace the asynchronous event loop found in
event driven network servers.

%description -n %libname
The libevent API provides a mechanism to execute a callback function
when a specific event occurs on a file descriptor or after a timeout
has been reached.

libevent is meant to replace the asynchronous event loop found in
event driven network servers.

%description devel
This package contains the header files, documentation, examples and
development library for use in developing applications that use the
libevent library.

%description devel-static
This package contains the static libevent library necessary to build
statically-linked libevent-based applications.

%prep
%setup
%patch -p1

%build
%autoreconf
# force epoll and /dev/epoll support
export haveepoll=yes
%configure %{subst_enable static} --disable-libevent-regress --disable-silent-rules
%make_build

%install
%makeinstall_std

# Relocate shared libraries from %_libdir/ to /%_lib/.
mkdir -p %buildroot/%_lib
for f in %buildroot%_libdir/*.so; do
	t=$(readlink "$f") || continue
	ln -snf ../../%_lib/"$t" "$f"
done
mv %buildroot%_libdir/*.so.* %buildroot/%_lib/

# Replace libevent.so symlink with the linker script.
rm %buildroot%_libdir/libevent.so
install -pm644 %_sourcedir/libevent.so %buildroot%_libdir/

%define docdir %_docdir/%name-%version
install -pD -m644 %_sourcedir/Makefile.sample \
	%buildroot%docdir/examples/Makefile
install -p -m644 sample/*.c %buildroot%docdir/examples/
install -pm644 LICENSE whatsnew-2.1.txt %buildroot%docdir/

#Install man
mkdir -p %buildroot%_man3dir
install -p -m644 *.3 %buildroot%_man3dir/

%check
%make_build -k check

%files -n %libname
/%_lib/*.so.*
%dir %docdir
%docdir/LICENSE
%docdir/whatsnew-2.1.txt

%files devel
%_bindir/event_rpcgen.py
%_libdir/*.so
%_includedir/*
%_pkgconfigdir/*
%_man3dir/*
%dir %docdir
%docdir/examples

%if_enabled static
%files devel-static
%_libdir/*.a
%endif

%changelog
