%define _unpackaged_files_terminate_build 1

Name: libfilezilla
Version: 0.50.0
Release: alt1
Summary: Small and modern C++ library
License: GPL-2.0-or-later
Group: System/Libraries
Url: https://lib.filezilla-project.org/

Source: %name-%version.tar

BuildRequires: cppunit-devel doxygen gcc-c++ graphviz libnettle-devel
BuildRequires: libgnutls-devel
BuildRequires: libgmp-devel

Conflicts: libfilezilla0 < %EVR
Obsoletes: libfilezilla0 < %EVR
Provides:  libfilezilla0 = %EVR

%description
libfilezilla is a free, open source C++ library, offering some basic
functionality to build high-performing, platform-independent programs.
Some of the highlights include:

* A typesafe, multi-threaded event system that's very simple to use yet
  extremely efficient.
* Timers for periodic events.
* A datetime class that not only tracks timestamp but also their
  accuracy, which simplifies dealing with timestamps originating from
  different sources.
* Simple process handling for spawning child processes with redirected
  I/O.

%package devel
Summary: Development package for %name
Group: Development/C++
Requires: %name = %EVR

%description devel
Header files for development with %name.

%prep
%setup

%build
%ifarch mipsel
export LIBS=-latomic
%endif

%configure \
	--disable-static \
	%nil

%make_build

pushd doc
make html
popd

%install
%makeinstall_std

find %buildroot -name '*.la' -delete

%find_lang %name

%check
LC_ALL=en_US.UTF-8 make check

%files -f %name.lang
%doc COPYING
%doc AUTHORS ChangeLog NEWS README
%_libdir/%name.so.*

%files devel
%doc doc/doxygen-doc/*
%_includedir/%name/
%_libdir/%name.so
%_pkgconfigdir/%name.pc

%changelog
