

%define oname libftgl
%define _unpackaged_files_terminate_build 1

Name: %{oname}2
Version: 2.4.0
Release: alt1
Summary: OpenGL frontend to Freetype 2

Group: System/Libraries
License: LGPLv2
Url: http://ftgl.wiki.sourceforge.net/
# https://github.com/frankheckenbach/ftgl
Source0: %name-%version.tar

# Automatically added by buildreq on Sun Aug 23 2009
BuildRequires: ImageMagick-tools cppunit-devel doxygen gcc-c++
BuildPreReq: libGL-devel libICE-devel libX11-devel libGLUT-devel
#BuildPreReq: libfreetype-devel texlive-extra-utils texlive-fonts-recommended
BuildPreReq: libfreetype-devel zlib-devel

Provides: %{oname}220 = %version-%release
Conflicts: libftgl213

%description
FTGL is a free open source library to enable developers to use arbitrary
fonts in their OpenGL (www.opengl.org)  applications.
Unlike other OpenGL font libraries FTGL uses standard font file formats
so doesn't need a preprocessing step to convert the high quality font data
into a lesser quality, proprietary format.
FTGL uses the Freetype (www.freetype.org) font library to open and 'decode'
the fonts. It then takes that output and stores it in a format most
efficient for OpenGL rendering.


%package -n %oname-devel
Summary: Development files for %name
Group: Development/C++
Requires: %name = %version-%release
Requires: pkgconfig
Requires: libfreetype-devel
Provides: ftgl-devel = %version
Provides: libftgl220-devel = %version-%release
Conflicts: libftgl213-devel

%description -n %oname-devel
The %oname-devel package contains libraries and header files for
developing applications that use %oname.



%package docs
Summary: Documentation for %name
Group: Documentation
BuildArch: noarch

%description docs
This package contains documentation files for %oname.


%prep
%setup

%build
touch msvc/Makefile.in
%autoreconf
%configure \
  --enable-shared \
  --disable-static \
  --with-gl-inc=%_includedir \
  --with-gl-lib=%_libdir \
  --with-glut-inc=%_includedir \
  --with-glut-lib=%_libdir \
  --with-x

%make_build

%install
%makeinstall_std
find %buildroot -name '*.la' -exec rm -f {} ';'

# install -p -m644 src/*.h %buildroot%_includedir/FTGL

# Doc fixes
mkdir -p __doc/html
install -pm 0644 %buildroot%_datadir/doc/ftgl/html/* __doc/html
rm -rf %buildroot%_datadir/doc

%files
%doc AUTHORS BUGS ChangeLog COPYING NEWS README TODO
%_libdir/*.so.*

%files -n %oname-devel
%_includedir/FTGL/
%_libdir/*.so
%_libdir/pkgconfig/*

%files docs
%doc __doc/*

%changelog
