%def_disable snapshot

%define _name libgee
%define ver_major 0.20
%define namespace Gee
%define api_ver 0.8
%def_disable static
%def_enable check

Name: %_name%api_ver
Version: %ver_major.8
Release: alt1

Summary: a collection library providing GObject-based interfaces
License: LGPL-2.1-or-later
Group: System/Libraries
Url: https://wiki.gnome.org/Projects/Libgee

Vcs: https://gitlab.gnome.org/GNOME/libgee.git

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%_name/%ver_major/%_name-%version.tar.xz
%else
Source: %_name-%version.tar
%endif

BuildRequires(pre): rpm-build-gir
# for AX_REQUIRE_DEFINED
BuildRequires: autoconf-archive
BuildRequires: libvala-devel vala-tools
BuildRequires: libgio-devel >= 2.36
BuildRequires: gobject-introspection-devel

%description
libgee is a collection library providing GObject-based interfaces and classes
for commonly used data structures.

The ArrayList, HashSet, and HashMap classes provide a reasonable sample
implementation of the List, Set, and Map interfaces. ReadOnlyCollection,
ReadOnlyList, ReadOnlySet, and ReadOnlyMap are read-only wrapper classes that
prevent modification of the underlying collection.

libgee is written in Vala and can be used like any GObject-based C
library. It's planned to provide bindings for further languages.

%package devel
Group: Development/C
Summary: Development files of %name
Provides: %_name-devel = %EVR
Requires: %name = %EVR

%description devel
libgee is a collection library providing GObject-based interfaces and classes
for commonly used data structures.

This package contains the C headers and libs required for building programs
with %name.

%package gir
Summary: GObject introspection data for the libgee library
Group: System/Libraries
Requires: %name = %EVR

%description gir
GObject introspection data for the libgee library

%package gir-devel
Summary: GObject introspection devel data for the libgee library
Group: System/Libraries
BuildArch: noarch
Requires: %name-gir = %EVR
Requires: %name-devel = %EVR

%description gir-devel
GObject introspection devel data for the libgee library

%if_enabled static
%package devel-static
Group: Development/C
Summary: Static library of %name
Requires: %name-devel = %EVR

%description devel-static
libgee is a collection library providing GObject-based interfaces and classes
for commonly used data structures.

This package contains the static library required for statically linking
applications with %name.

%endif #enabled static

%prep
%setup -n %_name-%version

%build
%autoreconf
%configure %{subst_enable static}
%make_build

%install
%makeinstall_std

%check
%make -k check VERBOSE=1

%files
%_libdir/libgee-%api_ver.so.*
%doc AUTHORS ChangeLog* MAINTAINERS NEWS README

%files devel
%_includedir/gee-%api_ver
%_libdir/libgee-%api_ver.so
%_pkgconfigdir/gee-%api_ver.pc
%_datadir/vala/vapi/gee-%api_ver.vapi

%files gir
%_typelibdir/%namespace-%api_ver.typelib

%files gir-devel
%_girdir/%namespace-%api_ver.gir

%if_enabled static
%files devel-static
%_libdir/*.a
%endif

%changelog
