%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

%define _oldname libglade2
%define ver_major 2.6
%def_disable static
%def_disable python
%def_disable gtk_doc

Name: libglade
Version: %ver_major.4
Release: alt6
Summary: libglade library
License: LGPL-2.0+
Group: System/Libraries
Url: ftp://ftp.gnome.org

Provides: %_oldname = %version
Obsoletes: %_oldname < %version

# ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.bz2
Source: %name-%version.tar

%define gtk_ver 2.5.0
%define glib_ver 2.10.0
%define atk_ver 1.9.0
%define libxml2_ver 2.6.17
%define pkgconfig_ver 0.15-alt3.2
%define python_ver 2.0

%define xmlcatalog %_sysconfdir/xml/catalog
PreReq: %xmlcatalog

BuildRequires: libgtk+2-devel >= %gtk_ver
BuildRequires: glib2-devel >= %glib_ver
BuildRequires: libatk-devel >= %atk_ver
BuildRequires: python >= %python_ver
BuildRequires: libxml2-devel >= %libxml2_ver
BuildRequires: pkgconfig >= %pkgconfig_ver

%if_enabled python
BuildRequires: PyXML python-modules-xml
%endif

BuildRequires: gtk-doc
BuildRequires: docbook-dtds docbook-style-xsl python-devel xml-utils xsltproc zlib-devel

%description
This library allows you to load user interfaces in your program, which are
stored externally.  This allows alteration of the interface without
recompilation of the program.

The interfaces can also be edited with GLADE.

%package devel
Summary: Libraries, includes, etc to develop libglade applications
Group: Development/GNOME and GTK+
Provides: %_oldname-devel = %version
Obsoletes: %_oldname-devel < %version
Requires: %name = %EVR

%description devel
This library allows you to load user interfaces in your program, which are
stored externally.  This allows alteration of the interface without
recompilation of the program.

Libraries, include files, etc you can use to develop libglade applications.

%if_enabled python
%package devel-converter
Summary: Python script to convert old glade files.
Group: Development/GNOME and GTK+
Provides: %_oldname-devel-python = %version %name-devel-python = %version
Obsoletes: %_oldname-devel-python < %version %name-devel-python < %version
Requires: %name-devel = %EVR

%description devel-converter
This library allows you to load user interfaces in your program, which are
stored externally.  This allows alteration of the interface without
recompilation of the program.

This package provides libglade-convert script to convert old glade files.
%endif

%package devel-doc
Summary: Development documentation for %name
Group: Development/GNOME and GTK+
BuildArch: noarch
Provides: %_oldname-devel-doc = %version
Obsoletes: %_oldname-devel-doc < %version
Conflicts: %name < %version

%description devel-doc
Glade library allows to load user interfaces in programs, which are
stored externally. This allows alteration of the interface without
recompilation of the program.

This package contains development documentation for %name

%if_enabled static
%package devel-static
Summary: Libraries, includes, etc to develop libglade applications
Group: Development/GNOME and GTK+
Requires: libgtk+2-devel libxml2-devel %name-devel = %EVR

%description devel-static
Libraries, include files, etc you can use to develop libglade applications.
%endif

%prep
%setup

# fix LTVERSION (2.4.1 was 0:5:0)
%__subst 's,0:4:0,0:6:0,' glade/Makefile*

# disable dependency on libxml2-devel
%__subst '/^Requires:/s/ libxml-2.0//' libglade-*.pc.in

%build
%if_disabled python
export ac_cv_path_PYTHON=/bin/false
%endif

%autoreconf
%configure \
	%{subst_enable static} \
	%{?_enable_gtk_doc:--enable-gtk-doc}

%make_build

%install
%makeinstall

# The directory for libglade extenstions.
%__mkdir_p %buildroot%_libdir/%name/2.0

# Development documentation.
%__mkdir_p %buildroot%_docdir/%name-devel-%version
%__cp test-libglade.c examples/*.glade %buildroot%_docdir/%name-devel-%version/

%post
%_bindir/xmlcatalog --noout --add "system" \
    "http://glade.gnome.org/glade-2.0.dtd" \
    %_datadir/xml/%name/glade-2.0.dtd %xmlcatalog ||:

%postun
%_bindir/xmlcatalog --noout --del \
    "%_datadir/xml/%name/glade-2.0.dtd" %xmlcatalog ||:

%files
%_libdir/%name-2.0.so.*
%dir %_libdir/%name
%dir %_libdir/%name/2.0
%dir %_datadir/xml/%name
%_datadir/xml/%name/glade-2.0.dtd
%doc AUTHORS NEWS README

%files devel
%_libdir/*.so
%_includedir/*
%_libdir/pkgconfig/*

%if_enabled python
%files devel-converter
%_bindir/libglade-convert
%endif

%files devel-doc
%_docdir/%name-devel-%version
%_datadir/gtk-doc/html/*

%if_enabled static
%files devel-static
%_libdir/*.a
%endif

%changelog
