%def_enable snapshot
%define _libexecdir %_prefix/libexec

%define oldname libgtop2
%define ver_major 2.41
%define api_ver 2.0
%define namespace GTop

%def_disable static
%def_with examples
%def_enable introspection
%def_enable daemon
%def_enable check

Name: libgtop
Version: %ver_major.3
Release: alt2

Summary: LibGTop library
License: GPL-2.0-or-later
Group: System/Libraries
Url: ftp://ftp.gnome.org

Obsoletes: %oldname < 2.14.2
Provides: %oldname = %EVR

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
%else
Source: %name-%version.tar
%endif
Patch2: %name-2.0.0-texinfo.patch
Patch4: %name-2.9.90-alt-examples_makefile.patch

# from configure.ac
%define glib_ver 2.26.0

BuildRequires(pre): rpm-build-gir
BuildRequires: glib2-devel >= %glib_ver
BuildRequires: gtk-doc >= 1.4
BuildRequires: makeinfo
BuildRequires: libICE-devel libX11-devel perl-XML-Parser
%{?_enable_static:BuildRequires: glibc-devel-static}
%{?_enable_introspection:BuildRequires: gobject-introspection-devel >= 0.6.7}

%description
LibGTop is a library that fetches information about the running
system such as CPU and memory useage, active processes and more.

On Linux systems, this information is taken directly from the /proc
filesystem while on other systems a server is used to read that
information from other /dev/kmem, among others.

%package daemon
Summary: The LibGTop Daemon
Group: System/Libraries
Requires: %name = %EVR

%description daemon
This package provides setuid root server/daemon which is usually does
not required on Linux systems.

%package examples
Summary: The LibGTop samples
Group: Development/GNOME and GTK+
Obsoletes: %oldname-examples < 2.14.2
Provides: %oldname-examples = %EVR
Requires: %name = %EVR

%description examples
This package contains some example of using %name library

%package devel
Summary: Development files for %name
Group: Development/GNOME and GTK+
Obsoletes: %oldname-devel < 2.14.2
Provides: %oldname-devel = %EVR
Requires: %name = %EVR

%description devel
LibGTop is a library that fetches information about the running
system such as CPU and memory useage, active processes and more.

Install this package if you wish to develop applications that access
information on system statistics such as CPU and memory usage.

%package devel-doc
Summary: Development documentation for %name
Group: Development/Documentation
Conflicts: %name-devel < %version-%release
BuildArch: noarch

%description devel-doc
LibGTop is a library that fetches information about the running
system such as CPU and memory useage, active processes and more.

This package contains development documentation for the library.

%package devel-static
Summary: Static libraries for %name
Group: Development/GNOME and GTK+
Obsoletes: %oldname-devel-static < 2.14.2
Provides: %oldname-devel-static = %EVR
Requires: %name-devel = %EVR

%description devel-static
This package contains static libraries for development with %name.

%package gir
Summary: GObject introspection data for the LibGTop library
Group: System/Libraries
Requires: %name = %EVR

%description gir
GObject introspection data for the LibGTop library

%package gir-devel
Summary: GObject introspection devel data for the LibGTop library
Group: Development/Other
BuildArch: noarch
Requires: %name-devel = %EVR
Requires: %name-gir = %EVR

%description gir-devel
GObject introspection devel data for the LibGTop library


%define _gtk_docdir %_datadir/gtk-doc/html

%prep
%setup
%patch2 -p1
%patch4 -p1

rm -rf doc/*.info

%build
%autoreconf
%configure \
    %{subst_enable static} \
    --enable-gtk-doc \
    %{subst_with examples}
%make_build

%install
%makeinstall_std
%find_lang %name

%check
%make -k check VERBOSE=1

%files -f %name.lang
%_libdir/*.so.*
%doc AUTHORS NEWS README

%if_enabled daemon
%files daemon
%_libexecdir/%{name}_daemon2
%attr(4711,root,root) %_libexecdir/%{name}_server2
%else
%exclude %_libexecdir/%{name}_daemon2
%exclude %_libexecdir/%{name}_server2
%endif

%if_with examples
%files examples
%dir %_libdir/%name
%_libdir/%name/*
%endif

%files devel
%_includedir/%name-%api_ver/
%_libdir/*.so
%_pkgconfigdir/*
%_infodir/*.info*

%files devel-doc
%_gtk_docdir/*

%if_enabled static
%files devel-static
%_libdir/*.a
%endif

%if_enabled introspection
%files gir
%_typelibdir/%namespace-%api_ver.typelib

%files gir-devel
%_girdir/%namespace-%api_ver.gir
%endif

%changelog
