%define _name gupnp
%define ver_major 1.6
%define api_ver 1.6

%def_disable static
%def_enable gtk_doc
%def_enable man
%def_enable introspection
%def_enable vala
# context and acl failed in hasher
%def_disable check

Name: lib%_name%api_ver
Version: %ver_major.9
Release: alt1

Summary: A framework for creating UPnP devices and control points
Group: System/Libraries
License: LGPL-2.1-or-later
Url: http://www.gupnp.org/

Vcs: https://gitlab.gnome.org/GNOME/gupnp.git

Source: ftp://ftp.gnome.org/pub/gnome/sources/%_name/%ver_major/%_name-%version.tar.xz

%define meson_ver 0.54
%define glib_ver 2.69
%define gssdp_ver 1.6.2
%define soup_api_ver 3.0
%define soup_ver 3.0.6

BuildRequires(pre): rpm-macros-meson >= %meson_ver rpm-build-gir rpm-build-python3
BuildRequires: meson libgio-devel >= %glib_ver libgssdp%api_ver-devel >= %gssdp_ver
BuildRequires: libxml2-devel libsoup%soup_api_ver-devel >= %soup_ver libuuid-devel
%{?_enable_vala:BuildRequires(pre): rpm-build-vala
BuildRequires: vala-tools}
%{?_enable_introspection:BuildRequires: gobject-introspection-devel libsoup%soup_api_ver-gir-devel
BuildRequires: libgssdp%api_ver-gir-devel}
%{?_enable_gtk_doc:BuildRequires: gtk-doc gi-docgen}
%{?_enable_man:BuildRequires: xsltproc docbook-style-xsl}

%description
gUPnP is an object-oriented open source framework for creating UPnP
devices and control points, written in C using GObject and libsoup.
The gUPnP API is intended to be easy to use, efficient and flexible.

%package devel
Summary: Development files and libraries for gUPnP
Group: Development/C
Requires: %name = %EVR

%description devel
gUPnP is an object-oriented open source framework for creating UPnP
devices and control points, written in C using GObject and libsoup.
The gUPnP API is intended to be easy to use, efficient and flexible.

This package provides files for development with gUPnP.

%package devel-doc
Summary: Development documentaion for gUPnP
Group: Development/C
BuildArch: noarch
Conflicts: %name < %version

%description devel-doc
gUPnP is an object-oriented open source framework for creating UPnP
devices and control points, written in C using GObject and libsoup.
The gUPnP API is intended to be easy to use, efficient and flexible.

This package provides development documentations for gUPnP.

%package gir
Summary: GObject introspection data for the gUPnP library
Group: System/Libraries
Requires: %name = %EVR

%description gir
GObject introspection data for the gUPnP library

%package gir-devel
Summary: GObject introspection devel data for the gUPnP library
Group: System/Libraries
BuildArch: noarch
Requires: %name-gir = %EVR

%description gir-devel
GObject introspection devel data for the gUPnP library


%prep
%setup -n %_name-%version
# fix manpage building
sed -i '/\--nowrite/d' doc/meson.build
%ifarch %e2k
# workaround for mcst#8784 as of lcc 1.27.14
sed -i 's/-Werror/-Wno-error/g' meson.build
%endif

%build
%meson \
%{?_enable_gtk_doc:-Dgtk_doc=true} \
%{?_disable_introspection:-Dintrospection=false} \
%{?_disable_vala:-Dvapi=false}
%nil
%meson_build

%install
%meson_install

%check
%__meson_test

%files
%_bindir/%_name-binding-tool-%api_ver
%_libdir/lib%_name-%api_ver.so.*
%{?_enable_man:%_man1dir/%_name-binding-tool*.1*}
%doc AUTHORS README* NEWS

%files devel
%_pkgconfigdir/%_name-%api_ver.pc
%_libdir/lib%_name-%api_ver.so
%_includedir/%_name-%api_ver/
%_vapidir/%_name-%api_ver.deps
%_vapidir/%_name-%api_ver.vapi

%if_enabled gtk_doc
%files devel-doc
%_datadir/doc/%_name-%api_ver/
%endif

%if_enabled introspection
%files gir
%_typelibdir/GUPnP-%api_ver.typelib

%files gir-devel
%_girdir/GUPnP-%api_ver.gir
%endif


%changelog
