%{?optflags_lto:%global optflags_lto %optflags_lto -ffat-lto-objects}

Name: libiir1
Version: 1.9.3
Release: alt1
Summary: DSP IIR Realtime C++ filter library

License: MIT
Group: Development/C
Url: https://berndporr.github.io/iir1/
Packager: Artyom Bystrov <arbars@altlinux.org>

Source: %name-%version.tar
# https://github.com/berndporr/iir1/pull/44
Patch: 0001-Install-CMake-files-to-libdir.patch

BuildRequires: cmake rpm-macros-cmake
BuildRequires: doxygen
BuildRequires: gcc-c++

%description
An infinite impulse response (IIR) filter library for Linux, Mac OSX and Windows
which implements Butterworth, RBJ, Chebychev filters and can easily import
coefficients generated by Python (scipy).

The filter processes the data sample by sample for realtime processing.

It uses templates to allocate the required memory so that it can run without any
malloc / new commands. Memory is allocated at compile time so that there is
never the risk of memory leaks.

All realtime filter code is in the header files which guarantees efficient
integration into the main program and the compiler can optimise both filter code
and main program at the same time.

%package devel
Summary: Development libraries and header files for %name
Group: Development/C
Requires: %name

%description devel
%summary.

%package devel-static
Summary: Development libraries for %name - static version
Group: Development/C
Requires: %name

%description devel-static
%summary.

%package devel-doc
Group: Development/Documentation
Summary: Development documentation for %name
Requires: %name-devel = %version-%release
BuildArch: noarch

%description devel-doc
%summary.

%prep
%setup
# Source contains prebuilt documentation, need to rebuild.
rm -rf docs

%build
%cmake 
%cmake_build
# Rebuild documentation
(cat Doxyfile; echo GENERATE_LATEX = NO ) | doxygen -

%install
%cmake_install

%files
%_libdir/libiir.so.1*
%doc COPYING

%files devel
%_includedir/Iir.h
%_includedir/iir
%_libdir/libiir.so
%_libdir/cmake/iir
%_pkgconfigdir/iir.pc

%files devel-static
%_libdir/libiir_static.a

%files devel-doc
%doc README.md
%doc title.png
%doc demo
%doc docs

%changelog
