%def_disable snapshot

%define _libexecdir %_prefix/libexec
%def_enable libwacom
%def_enable debug_gui
%def_enable documentation
%ifarch %ix86
%def_disable tests
%def_disable install_tests
%else
%def_enable tests
%def_enable install_tests
%endif

Name: libinput
Version: 1.29.0
Release: alt1

Summary: Input devices library
Group: System/Libraries
License: MIT
Url: http://www.freedesktop.org/wiki/Software/libinput/

Vcs: https://gitlab.freedesktop.org/libinput/libinput.git

%if_disabled snapshot
Source: https://gitlab.freedesktop.org/%name/%name/-/archive/%version/%name-%version.tar.bz2
%else
Source: %name-%version.tar
%endif

%add_python3_path %_libexecdir/%name

%define mtdev_ver 1.1.0
%define evdev_ver 1.10

BuildRequires(pre): rpm-macros-meson rpm-build-python3 pkgconfig(udev)
# for %%valgrind_arches
BuildRequires(pre): rpm-macros-valgrind
BuildRequires: meson gcc-c++
BuildRequires: libmtdev-devel >= %mtdev_ver libevdev-devel >= %evdev_ver
BuildRequires: libudev-devel pkgconfig(systemd)
BuildRequires: libcheck-devel
%{?_enable_libwacom:BuildRequires: libwacom-devel}
%{?_enable_debug_gui:BuildRequires: wayland-protocols
%ifarch %e2k
BuildRequires: libgtk+3-devel
%else
BuildRequires: libgtk4-devel
%endif
}
%{?_enable_documentation:BuildRequires: doxygen graphviz yq
BuildRequires: python3(sphinx) python3(sphinx_rtd_theme) python3(recommonmark)}
%{?!_without_check:%{?!_disable_check:
BuildRequires: /proc gdb  python3-module-pytest python3-module-pytest-xdist
BuildRequires: python3-module-pyparsing
%ifarch %valgrind_arches
BuildRequires: valgrind
%endif
}}

%description
libinput is a library that handles input devices for display servers and
other applications that need to directly deal with input devices.

It provides device detection, device handling, input device event
processing and abstraction so minimize the amount of custom input code
the user of libinput need to provide the common set of functionality
that users expect.

Input event processing includes scaling touch coordinates, generating
pointer events from touchpads, pointer acceleration, etc.

%package devel
Summary: libinput development package
Group: Development/C
Requires: %name = %EVR

%description devel
This package contains development libraries and header files
that are needed to write applications that use %name.

%package tools
Summary: tools for %name
Group: Development/Tools
Requires: %name = %EVR

%description tools
This package contains commandline tools from %name package.

%package tools-gui
Summary: libinput visual debug helper
Group: Development/Tools
Requires: %name = %EVR
Requires: %name-tools = %EVR

%description tools-gui
This package contains visual debug helper for %name.

%package tests
Summary: Tests for libinput
Group: Development/Other
Requires: %name = %EVR

%description tests
This package provides tests programs that can be used to verify
the functionality of the installed libinput library.

%prep
%setup

%build
%meson %{subst_enable_meson_bool libwacom libwacom} \
       %{subst_enable_meson_bool debug_gui debug-gui} \
       %{subst_enable_meson_bool documentation documentation} \
       %{subst_enable_meson_bool tests tests} \
       %{subst_enable_meson_bool install_tests install-tests} \
       -Dudev-dir=%_udevdir
%meson_build

%install
%meson_install

%check
%__meson_test -t 4 --no-suite hardware --no-suite root

%files
%dir %_sysconfdir/%name
%_libdir/%name.so.*
%_udevdir/%name-device-group
%_udevdir/%name-fuzz-extract
%_udevdir/%name-fuzz-to-zero
%_datadir/%name/
%_udevrulesdir/80-%name-device-groups.rules
%_udevrulesdir/90-%name-fuzz-override.rules
%doc COPYING README*

%files devel
%_includedir/%name.h
%_libdir/%name.so
%_pkgconfigdir/%name.pc

%files tools
%_bindir/%name
%dir %_libexecdir/%name
%_libexecdir/%name/%name-analyze
%_libexecdir/%name/%name-analyze-buttons
%_libexecdir/%name/%name-analyze-per-slot-delta
%_libexecdir/%name/%name-analyze-recording
%_libexecdir/%name/%name-analyze-touch-down-state
%_libexecdir/%name/%name-debug-events
%_libexecdir/%name/%name-debug-tablet
%_libexecdir/%name/%name-debug-tablet-pad
%_libexecdir/%name/%name-list-devices
%_libexecdir/%name/%name-list-kernel-devices
%_libexecdir/%name/%name-measure
%_libexecdir/%name/%name-measure-fuzz
%_libexecdir/%name/%name-measure-touchpad-pressure
%_libexecdir/%name/%name-measure-touchpad-size
%_libexecdir/%name/%name-measure-touchpad-tap
%_libexecdir/%name/%name-measure-touch-size
%_libexecdir/%name/%name-quirks
%_libexecdir/%name/%name-record
%_libexecdir/%name/%name-replay
%_libexecdir/%name/%name-test
%_man1dir/%name.1.*
%_man1dir/%name-analyze.1*
%_man1dir/%name-analyze-buttons.1*
%_man1dir/%name-analyze-per-slot-delta.1*
%_man1dir/%name-analyze-recording.1*
%_man1dir/%name-analyze-touch-down-state.1*
%_man1dir/%name-debug-events.1.*
%_man1dir/%name-debug-tablet.1.*
%_man1dir/%name-debug-tablet-pad.1*
%_man1dir/%name-list-devices.1.*
%_man1dir/%name-list-kernel-devices.1.*
%_man1dir/%name-measure.1.*
%_man1dir/%name-measure-fuzz.1.*
%_man1dir/%name-measure-touchpad-pressure.1.*
%_man1dir/%name-measure-touchpad-size.1*
%_man1dir/%name-measure-touchpad-tap.1.*
%_man1dir/%name-measure-touch-size.1.*
%_man1dir/%name-quirks.1.*
%_man1dir/%name-quirks-list.1.*
%_man1dir/%name-quirks-validate.1.*
%_man1dir/%name-record.1.*
%_man1dir/%name-replay.1.*
%_man1dir/%name-test.1.*
%_datadir/zsh/site-functions/_%{name}

%if_enabled debug_gui
%files tools-gui
%_libexecdir/%name/%name-debug-gui
%_man1dir/%name-debug-gui.1.*
%endif

%if_enabled install_tests
%files tests
%_libexecdir/%name/%name-test-suite
%_libexecdir/%name/%name-test-utils
%_man1dir/%name-test-suite.1.*
%endif

%changelog
