%define abiversion 7

Name: libjasper
Version: 4.2.3
Release: alt1

Summary: Implementation of the codec specified in the JPEG-2000 Part-1 standard
Summary(ru_RU.UTF8): Реализация кодеков по спецификации стандарта JPEG-2000, часть I

License: Modified BSD
Group: System/Libraries
Url: https://github.com/jasper-software/jasper

Packager: Vitaly Lipatov <lav@altlinux.ru>

# Source-url: https://github.com/mdadams/jasper/archive/version-%version.tar.gz
Source: %name-%version.tar

BuildRequires(pre): rpm-macros-cmake
BuildRequires: cmake
BuildRequires: libjpeg-devel
BuildRequires: libGL-devel libXext-devel libXi-devel libXmu-devel libglut-devel

%description
JasPer is a collection of software (i.e., a library and application programs) for the coding
and manipulation of images.  This software can handle image data in a
variety of formats.  One such format supported by JasPer is the JPEG-2000
format defined in ISO/IEC 15444-1:2000.

%package -n %name%abiversion
Summary: Implementation of the codec specified in the JPEG-2000 Part-1 standard
Group: System/Libraries

%description -n %name%abiversion
JasPer is a collection of software (i.e., a library and application programs) for the coding
and manipulation of images.  This software can handle image data in a
variety of formats.  One such format supported by JasPer is the JPEG-2000
format defined in ISO/IEC 15444-1:2000.


%package devel
Summary: Include Files for %name
Group: Development/C
Requires: %name%abiversion = %EVR

%description devel
Libraries/include files for development with %name.

%package devel-doc
Summary: Documentation for %name
Group: Development/C
BuildArch: noarch

%description devel-doc
Documentation for development with %name.

%package -n jasper
Summary: JasPer utilities
Group: Graphics
Requires: %name%abiversion = %EVR

%description -n jasper
JasPer is a collection
of software (i.e., a library and application programs) for the coding
and manipulation of images.  This software can handle image data in a
variety of formats.  One such format supported by JasPer is the JPEG-2000
code stream format defined in ISO/IEC 15444-1:2000.

%prep
%setup
# fix bug with glut detection
#subst "s|.*GLUT_glut_LIBRARY.*||" build/cmake/modules/JasOpenGL.cmake

%build
# TODO: -DJAS_ENABLE_HIDDEN=true
%cmake -DJAS_ENABLE_AUTOMATIC_DEPENDENCIES=OFF \
       -DJAS_ENABLE_DOC=OFF \
       -DALLOW_IN_SOURCE_BUILD=ON
%cmake_build

%install
%cmakeinstall_std

%files -n %name%abiversion
%doc README.md LICENSE.txt
%_libdir/libjasper.so.%abiversion
%_libdir/libjasper.so.%abiversion.0.0

%files -n jasper
%_bindir/imgcmp
%_bindir/imginfo
%_bindir/jasper
%_bindir/jiv
%_man1dir/*

%files devel
%_includedir/jasper/
%_libdir/libjasper.so
%_pkgconfigdir/jasper.pc

%files devel-doc
%doc %_docdir/JasPer/

%changelog
