Name: libjpeg8
Version: 3.0.3
Release: alt1
Summary: The MMX/SSE accelerated JPEG compression/decompression library
License: IJG and BSD-3-Clause and Zlib
Group: System/Libraries
Url: https://libjpeg-turbo.org/

Source: https://github.com/libjpeg-turbo/libjpeg-turbo/archive/%version/libjpeg-turbo-%version.tar.gz
Patch: libjpeg-turbo14-noinst.patch
Patch1: libjpeg-turbo-header-files.patch
Patch11: libjpeg-turbo-alt-header-files.patch

BuildRequires(pre): rpm-build-ninja
BuildRequires: cmake gcc

%description
The libjpeg8 package contains a library of functions for manipulating JPEG images.

%prep
%setup -n libjpeg-turbo-%version
%patch11 -p1
chmod -x README.md

%build
%cmake \
    -GNinja \
    -DENABLE_STATIC=false \
    -DWITH_TURBOJPEG=false \
    -DWITH_JPEG8=true \
#
cmake --build "%_cmake__builddir" -j%__nprocs

%install
%cmake_install
find %buildroot -name "*.la" -delete

# We need only shared library for this package, so we will remove
# all other installed by default make sequence files.
rm -f %buildroot%_bindir/{cjpeg,djpeg,jpegtran,rdjpgcom,wrjpgcom}
rm -f %buildroot%_libdir/libjpeg.so
rm -rf %buildroot%_pkgconfigdir
rm -rf %buildroot%_includedir
rm -rf %buildroot%_mandir
# Packaged using %%doc
rm -rf %buildroot%_datadir/doc/libjpeg-turbo
rm -rf %buildroot%_libdir/cmake/libjpeg-turbo/*.cmake

%files
%doc README.md ChangeLog.md LICENSE.md README.ijg
%_libdir/libjpeg.so.8*

%changelog
