%define _unpackaged_files_terminate_build 1

%def_disable static
%def_disable python
%define sname keybinder

Name: libkeybinder
Version: 0.3.1
Release: alt1
Summary: keybinder is a library for registering global keyboard shortcuts
License: GPLv2
Group: System/Libraries
Url: https://github.com/engla/keybinder

BuildRequires: libgtk+2-devel xorg-server-common libXext-devel gobject-introspection-devel
BuildRequires: python-devel
%if_enabled python
BuildRequires: python-module-pygtk-devel
%endif
BuildRequires: gtk-doc

# https://github.com/engla/keybinder.git
Source: %name-%version.tar

%description
keybinder is a library for registering global keyboard shortcuts.
Keybinder works with GTK-based applications using the X Window System.
The library contains:
 - A C library, libkeybinder
 - Lua bindings, lua-keybinder
 - Python bindings, python-keybinder
 - An examples directory with programs in C, Lua, Python and Vala.


%package gir
Summary: GObject introspection data for the %name library
Group: System/Libraries
Requires: %name = %EVR

%description gir
GObject introspection data for the %name library

%package devel
Summary: Headers for %name
Group: Development/C
Requires: %name = %EVR

%description devel
Headers for building software that uses %name

%package gir-devel
Summary: GObject introspection devel data for the %name
Group: System/Libraries
BuildArch: noarch
Requires: %name-gir = %EVR

%description gir-devel
GObject introspection devel data for the %name library

%if_enabled static
%package devel-static
Summary: Static libraries for %name
Group: Development/C
Requires: %name-devel = %EVR

%description devel-static
Static libs for building statically linked software that uses %name
%endif

%package -n python-module-keybinder
Summary: Python binding to %name
Group: Development/Python
Requires: %name = %EVR

%description -n python-module-%sname
Python binding to %name

%prep
%setup

%build
%autoreconf -I m4
%configure \
	%{subst_enable static} \
	--disable-gtk-doc \
	--with-html-dir=%_docdir \
	--disable-lua \
	%{subst_enable python} \
	%nil

%make_build V=1

%install
%makeinstall_std

%files
%doc AUTHORS README NEWS
%_libdir/*.so.*

%files devel
%_includedir/*.h
%_libdir/*.so
%_pkgconfigdir/*.pc

%if_enabled static
%files devel-static
%_libdir/lib%name.a
%endif

%if_enabled python
%files -n python-module-%sname
%python_sitelibdir/%sname
%endif

%files gir
%_typelibdir/*

%files gir-devel
%_girdir/*

%changelog
