%def_disable static

Name: libmcrypt
Version: 2.5.8
Release: alt3

Summary: Encryption/decryption library

License: LGPLv2
Group: System/Libraries
Url: http://mcrypt.sourceforge.net/

Packager: Vitaly Lipatov <lav@altlinux.ru>

# Source-url: http://dl.sf.net/%name/%name-%version.tar.bz2
Source: %name-%version.tar
Patch: libmcrypt-2.5.7-alt-libdl.patch
Patch1: libmcrypt-2.5.1-dlopen.patch
Patch2: libmcrypt-2.5.1-symbols.patch
Patch3: libmcrypt-2.5.1-extra.patch
Patch4: libmcrypt-2.5.7-automake.patch
Patch5: libmcrypt-2.5.8-nolibltdl.patch

Source1: mcrypt_symb.c

# Automatically added by buildreq on Sat May 19 2012
# optimized out: libstdc++-devel
BuildRequires: gcc-c++ glibc-devel

%package devel
Summary: Development environment for %name
Group: Development/Other
Requires: %name = %version-%release

%package devel-static
Summary: Development environment for %name
Group: Development/Other
Requires: %name-devel = %version-%release

%description
The libmcrypt is a data encryption library. The library is thread safe
and provides encryption and decryption functions. This version of the
library supports many encryption algorithms and encryption modes. Some
algorithms which are supported: SERPENT, RIJNDAEL, 3DES, GOST, SAFER+,
CAST-256, RC2, XTEA, 3WAY, TWOFISH, BLOWFISH, ARCFOUR, WAKE and more.

%description devel
This package contains the header files and libraries needed
to develop programs that use the %name library.

%description devel-static
This package contains static libraries.

%prep
%setup
%patch -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch5 -p1

%__subst 's,libmcrypt_la_LIBADD = @EXTRA_OBJECTS@,,' lib/Makefile.am

(cd modules
    find . -type f -name '*.c'|xargs %__subst 's/#define _.*//'
)

# only invalid libtool.m4 inclusion
rm -v acinclude.m4
rm -rv libltdl/

# autoreconf-default: warning: autoconf input should be named 'configure.ac', not 'configure.in'
mv -v configure.in configure.ac

%build
%autoreconf
# Since 2.5.4 libmcrypt does not use dynamic loading for the modules by default
%configure %{subst_enable static} --disable-ltdl \
           --disable-libtool-lock --disable-dynamic-loading

cp %SOURCE1 lib

%make_build 

%install
%makeinstall_std

mkdir -p %buildroot%_libdir/%name

for i in  modes algorithms
do
    cp modules/$i/.libs/*.so %buildroot%_libdir/%name
%if_enabled static
    cp modules/$i/.libs/*.a %buildroot%_libdir/%name
%endif
done

%files
%_libdir/*.so.*
%dir %_libdir/%name
%_libdir/%name/*.so

%files devel
%doc AUTHORS NEWS README THANKS TODO doc/{README.*,example.c}
%_bindir/*
%_libdir/*.so
%_includedir/*
%_mandir/man?/*
%_datadir/aclocal/*

%if_enabled static
%files devel-static
%_libdir/*.a
%_libdir/%name/*.a
%endif

# TODO: add test for module working (from example?)
# TODO: remove strange hacking for build & install

%changelog
