%define oname msgpack-c
%define oldname libmsgpack
Name: libmsgpack-c
Version: 6.0.1
Release: alt1

Summary: Binary-based efficient object serialization library for C

License: BSL-1.0
Group: System/Libraries
Url: http://msgpack.org

# Source-url: https://github.com/msgpack/%oname/archive/refs/tags/c-6.0.0.tar.gz
Source: %name-%version.tar
BuildRequires: cmake zlib-devel
# Tests are written in C++
BuildRequires: gcc-c++

# for %%check
BuildRequires: ctest libgtest-devel

Provides: %oname = %version-%release
Obsoletes: %oname

%description
MessagePack is a binary-based efficient object serialization
library. It enables to exchange structured objects between many
languages like JSON. But unlike JSON, it is very fast and small.

%package devel
Summary: Libraries and header files for %name
Group: Development/C
Requires: %name = %version-%release

Conflicts: %oldname-devel

%description devel
Libraries and header files for %name

%prep
%setup
subst "s|/lib|/%_lib|g" CMakeLists.txt

%build
%cmake_insource -DCMAKE_INSTALL_LIBDIR=%_lib -DBUILD_SHARED_LIBS=ON -DMSGPACK_CXX11=ON
%make_build

%check
export LD_LIBRARY_PATH=$(pwd)
%make test

%install
%makeinstall_std

%files
%doc COPYING LICENSE_1_0.txt NOTICE README.md
%_libdir/*.so.*

%files devel
%_includedir/msgpack.*
%_includedir/msgpack/
%_libdir/*.so
%_pkgconfigdir/msgpack-c.pc
%_libdir/cmake/msgpack-c/

%changelog
