%define _name libopenshot
%define ver_major 0.4
%define api_ver 9
%define libopenshot_ver 0.4

# no tests
%def_disable check

Name: %_name-audio
Version: %ver_major.0
Release: alt1

Summary: OpenShot Audio Library
Group: System/Libraries
License: GPL-3.0-or-later
Url: https://launchpad.net/%_name

Vcs: https://github.com/OpenShot/libopenshot-audio.git

#Source: %url/%ver_major/%libopenshot_ver/+download/%name-%version.tar.gz
Source: https://github.com/OpenShot/%name/archive/v%version/%name-%version.tar.gz

%define python_ver 3.0

BuildRequires(pre): rpm-macros-cmake rpm-build-python3
BuildRequires: cmake gcc-c++ python3 >= %python_ver zlib-devel libalsa-devel libfreetype-devel
%{?_enable_check:BuildRequires: ctest}

%description
OpenShot Audio Library is a program that allows the high-quality editing
and playback of audio, and is based on the amazing JUCE library.

%package devel
Summary: OpenShot Audio Library development package
Group: Development/C++
Requires: %name = %EVR

%description devel
This package contains development libraries and header files
that are needed to write applications that use %name.

%prep
%setup

%build
%add_optflags %(getconf LFS_CFLAGS)
%ifarch %e2k
%add_optflags -DJUCE_NO_INLINE_ASM=1 -DJUCE_USE_SIMD=0
%endif
%cmake \
    -DENABLE_AUDIO_DOCS=OFF
%cmake_build

%install
%cmake_install

%check
%cmake_build -t test

%files
%_bindir/openshot-audio-demo
%_libdir/%name.so.*
%_man1dir/openshot-audio-demo.1.*
%doc AUTHORS README*

%files devel
%_includedir/%name/
%_libdir/%name.so
%_libdir/cmake/OpenShotAudio/

%changelog
