# SPDX-License-Identifier: GPL-2.0-only
%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

Name: liboqs
Version: 0.12.0
Release: alt1
Summary: C library for prototyping and experimenting with quantum-resistant cryptography
License: MIT and BSD-3-Clause and Apache-2.0 and ALT-Public-Domain and CC0-1.0
Group: System/Libraries
Url: https://openquantumsafe.org/liboqs/
Vcs: https://github.com/open-quantum-safe/liboqs/
# NIST: https://csrc.nist.gov/Projects/post-quantum-cryptography/

Source: %name-%version.tar
BuildRequires(pre): rpm-macros-cmake
BuildRequires(pre): rpm-macros-ninja-build
BuildRequires: astyle
BuildRequires: banner
BuildRequires: chrpath
BuildRequires: cmake
BuildRequires: libssl-devel
BuildRequires: ninja-build
BuildRequires: python3-module-pyaml
BuildRequires: python3-module-pytest
BuildRequires: python3-module-pytest-xdist

%description
liboqs is part of the Open Quantum Safe (OQS) project led by Douglas
Stebila and Michele Mosca, which aims to develop and integrate into
applications quantum-safe cryptography to facilitate deployment and
testing in real world contexts.

Supported key encapsulation mechanisms (KEMs): BIKE, Classic McEliece,
  FrodoKEM, HQC, CRYSTALS-Kyber, NTRU-Prime.

Supported signature schemes: CRYSTALS-Dilithium, Falcon, SPHINCS+.

Warning: WE DO NOT CURRENTLY RECOMMEND RELYING ON THIS LIBRARY IN A
PRODUCTION ENVIRONMENT OR TO PROTECT ANY SENSITIVE DATA. This library is
meant to help with research and prototyping. While we make a best-effort
approach to avoid security bugs, this library has not received the level
of auditing and analysis that would be necessary to rely on it for high
security use. See Limitations and Security in README.md.

%package devel
Summary: %summary
Group: Development/C
Requires: %name = %EVR

%description devel
Development files for %name.

%package tests
Summary: Tests utilites from liboqs
Group: Development/Tools
Requires: %name = %EVR

%description tests
Tests that run different OQS algorithms.

%prep
%setup
# Add armh to the list of supported arm32 arches.
sed -i '/CMAKE_SYSTEM_PROCESSOR.*armhf/s/")/|armv8l&/' CMakeLists.txt

%build
%define optflags_lto %nil
%add_optflags %(getconf LFS_CFLAGS)
# CMake options https://github.com/open-quantum-safe/liboqs/wiki/Customizing-liboqs
# -DOQS_ENABLE_TEST_CONSTANT_TIME=ON -- does not pass.
%cmake -B build \
	-GNinja \
	-DCMAKE_ASM_FLAGS='%optflags' \
	-DCMAKE_BUILD_TYPE=RelWithDebInfo \
	-DBUILD_SHARED_LIBS=ON \
	-DOQS_DIST_BUILD=ON \
	-DOQS_OPT_TARGET=generic
%ninja_build -C build --verbose

%install
%ninja_install -C build

cp -a build/tests build-tests
pushd build-tests
find -maxdepth 1 -type f -perm -1 -printf '%%f\n' | xargs -i -n1 mv {} oqs-{}
rename '_' '-' oqs-*_*
rename '_' '-' oqs-*_*
chrpath -k oqs-* | grep RPATH= | cut -d: -f1 | xargs chrpath -d
install -Dp oqs-* -t %buildroot%_bindir
popd

%check
if [[ "%version-%release" == *rc* ]]; then
	grep -F '#define OQS_VERSION_TEXT'
else
	grep -Fx '#define OQS_VERSION_TEXT "%version"'
fi < %buildroot%_includedir/oqs/oqsconfig.h
export LD_LIBRARY_PATH=%buildroot%_libdir
%buildroot/%_bindir/oqs-kat-kem ||:
%buildroot/%_bindir/oqs-kat-sig ||:
banner tests
# Tests require lowercase 'build' dir.
export LD_LIBRARY_PATH=$PWD/build/lib
# https://github.com/open-quantum-safe/liboqs/wiki/Minimal-example-of-a-post-quantum-signature
  cc -Ibuild/include -Lbuild/lib tests/example_sig.c -o example_sig -loqs
  ./example_sig
# https://github.com/open-quantum-safe/liboqs/wiki/Minimal-example-of-a-post-quantum-KEM
  cc -Ibuild/include -Lbuild/lib tests/example_kem.c -o example_kem -loqs
  ./example_kem
time timeout --kill-after=300 200 %ninja_build -C build run_tests

%files
%doc LICENSE.txt README.md RELEASE.md SECURITY.md
%_libdir/liboqs.so.*

%files devel
%doc LICENSE.txt README.md RELEASE.md CONTRIBUTORS CODE_OF_CONDUCT.md
%doc tests/example_*.c docs/algorithms
%_includedir/oqs
%_libdir/cmake/liboqs
%_libdir/liboqs.so
%_pkgconfigdir/liboqs.pc

%files tests
%_bindir/oqs-*

%changelog
