%def_disable snapshot
%define _libexecdir %_prefix/libexec

%define _name pango
%define ver_major 1.56
%define api_ver 1.0
%define module_ver 1.8.0
%def_disable static
%def_enable docs
%def_enable man
%def_enable introspection
# no installed tests since 1.54.0
%def_disable installed_tests
%def_enable xft
%def_enable fontconfig
%def_enable freetype
%def_enable cairo
%def_enable libthai
%def_disable sysprof
# 25/29 /layout/valid-20.layout FAIL for sisyphus
%ifarch %ix86 armh
%def_disable check
%else
%def_enable check
%endif

Name: lib%_name
Version: %ver_major.4
Release: alt1

Summary: System for layout and rendering of internationalized text
License: LGPL-2.1-or-later
Group: System/Libraries
Url: https://www.pango.org/

Vcs: https://gitlab.gnome.org/GNOME/pango.git

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%_name/%ver_major/%_name-%version.tar.xz
%else
Source: %_name-%version.tar
%endif

Source10: pango-compat.map
Source11: pango-compat.lds
Source12: pangoft2-compat.map
Source13: pangoft2-compat.lds
Source14: pangocairo-compat.map
Source15: pangocairo-compat.lds

Patch: pango-1.50-alt-compat-version-script.patch

Provides: %_name = %version
Obsoletes: %_name < %version
Obsoletes: gscript

%define meson_ver 1.2
%define glib_ver 2.82
%define cairo_ver 1.18
%define gi_docgen_ver 2021.3
%define xft_ver 2.0.0
%define fontconfig_ver 2.15.0
%define freetype_ver 2.1.4
%define gi_ver 0.9.5
%define hb_ver 8.4.0
%define thai_ver 0.1.9
%define fribidi_ver 1.0.6

BuildRequires(pre): rpm-macros-meson
BuildRequires: meson >= %meson_ver gcc-c++ /proc
BuildRequires: glib2-devel >= %glib_ver libgio-devel
BuildRequires: libharfbuzz-devel >= %hb_ver
BuildRequires: libfribidi-devel >= %fribidi_ver
%{?_enable_xft:BuildRequires: libXft-devel >= %xft_ver}
%{?_enable_fontconfig:BuildRequires: fontconfig-devel >= %fontconfig_ver}
%{?_enable_freetype:BuildRequires: libfreetype-devel >= %freetype_ver}
%{?_enable_cairo:BuildRequires: libcairo-devel >= %cairo_ver libcairo-gobject-devel}
%{?_enable_libthai:BuildRequires: libthai-devel >= %thai_ver}
# since 1.48.3 gi-docgen used
%{?_enable_docs:BuildRequires: gi-docgen >= %gi_docgen_ver /usr/bin/rst2html5}
%{?_enable_man:BuildRequires: /usr/bin/rst2man}
%{?_enable_introspection:BuildRequires(pre): rpm-build-gir
BuildRequires: gobject-introspection-devel >= %gi_ver libharfbuzz-gir-devel}
%{?_enable_sysprof:BuildRequires: pkgconfig(sysprof-capture-4)}
%{?_enable_check:BuildRequires: gcc-c++ fonts-otf-abattis-cantarell fonts-otf-adobe-source-sans-pro
BuildRequires: fonts-ttf-google-droid-sans fonts-ttf-thai-scalable-waree}

%description
A library to handle unicode strings as well as complex bidirectional
or context dependent shaped strings.

%package devel
Summary: Development libraries and header files for pango
Group: Development/C
Provides: %_name-devel = %version
Obsoletes: %_name-devel < %version
Requires: %name = %EVR

%description devel
The pango-devel package includes the libraries and header files
for the pango package.

%package devel-doc
Summary: Development documentation for Pango
Group: Development/Documentation
Conflicts: %name < %version-%release
BuildArch: noarch

%description devel-doc
Pango is a library to handle unicode strings as well as complex
bidirectional or context dependent shaped strings.

This package contains development documentation for Pango.

%if_enabled static
%package devel-static
Summary: Static libraries for pango
Group: Development/C

%description devel-static
The pango-devel package includes the static libraries for the pango package.
%endif

%package gir
Summary: GObject introspection data for the Pango library
Group: System/Libraries
Requires: %name = %EVR

%description gir
GObject introspection data for the Pango library

%package gir-devel
Summary: GObject introspection devel data for the Pango library
Group: Development/Other
BuildArch: noarch
Requires: %name-gir = %version-%release

%description gir-devel
GObject introspection devel data for the Pango library

%package tests
Summary: Tests for the Pango library
Group: Development/Other
Requires: %name = %EVR

%description tests
This package provides tests programs that can be used to verify
the functionality of the installed Pango library.

%prep
%setup -n %_name-%version
%patch -p1 -b .vs
install -p -m644 %_sourcedir/pango{,ft2,cairo}-compat.{map,lds} pango/
# remove broken for sisyphus valid-20.layout test
rm -f tests/layouts/valid-20.layout

%build
%meson \
    %{?_disable_xft:-Dxft=disabled} \
    %{?_disable_fontconfig:-Dfontconfig=disabled} \
    %{?_disable_freetype:-Dfreetype=disabled} \
    %{?_disable_cairo:-Dcairo=disabled} \
    %{?_disable_libthai:-Dlibthai=disabled} \
    %{?_disable_introspection:-Dintrospection=disabled} \
    %{subst_enable_meson_bool docs documentation} \
    %{subst_enable_meson_bool man man-pages} \
    %{?_enable_sysprof:-Dsysprof=enabled}
%nil
%meson_build

%install
%meson_install

%check
%__meson_test -v

%files
%_bindir/%_name-list
%_bindir/%_name-view
%{?_enable_cairo:%_bindir/%_name-segmentation}
%_libdir/%name-%api_ver.so.*
%_libdir/%{name}cairo-%api_ver.so.*
%_libdir/%{name}ft2-%api_ver.so.*
%_libdir/%{name}xft-%api_ver.so.*
%{?_enable_man:%_man1dir/%_name-view.1*
%_man1dir/%_name-list.1*
%_man1dir/%_name-segmentation.1*}
%doc NEWS README*

%files devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*.pc

%if_enabled introspection
%files gir
%_typelibdir/Pango-%api_ver.typelib
%_typelibdir/PangoCairo-%api_ver.typelib
%_typelibdir/PangoFc-%api_ver.typelib
%_typelibdir/PangoFT2-%api_ver.typelib
%_typelibdir/PangoOT-%api_ver.typelib
%_typelibdir/PangoXft-%api_ver.typelib

%files gir-devel
%_girdir/*.gir
%endif

%if_enabled docs
%files devel-doc
%_datadir/doc/Pango
%_datadir/doc/PangoCairo
%_datadir/doc/PangoFc
%_datadir/doc/PangoFT2
%_datadir/doc/PangoOT
%_datadir/doc/PangoXft
%endif

%if_enabled static
%files devel-static
%_libdir/*.a
%_libdir/%_name/%module_ver/*/*.a
%endif

%if_enabled installed_tests
%files tests
%_libexecdir/installed-tests/%_name/
%_datadir/installed-tests/%_name/
%endif


%changelog
