%define soname 2

Name: libpaper
Version: 2.1.3
Release: alt1
Epoch: 2

Summary: Library and tools for handling papersize

# This is the license for the source package:
License: LGPL-2.1-or-later AND ALT-Public-Domain AND GPL-3.0-or-later AND GPL-2.0-only
Group: System/Libraries
Url: https://github.com/rrthomas/libpaper

# Source-url: https://github.com/rrthomas/libpaper/releases/download/v%version/libpaper-%version.tar.gz
Source: %name-%version.tar

BuildRequires(pre): rpm-macros-cmake

# Automatically added by buildreq on Sun Jan 08 2006
BuildRequires: gcc-c++ libstdc++-devel

%description
The paper library and accompanying files are intended to provide a simple
way for applications to take actions based on a system- or user-specified
paper size.  This release is quite minimal, its purpose being to provide
really basic functions (obtaining the system paper name and getting
the height and width of a given kind of paper) that applications can
immediately integrate.

%package -n %name%soname
Summary: Library and tools for handling papersize
# The library is licensed under LGPL-2.1-or-later, and the paperspecs file is
# in the public domain.
License: LGPL-2.1-or-later AND ALT-Public-Domain
Group: System/Libraries

%description -n %name%soname
The paper library and accompanying files are intended to provide a simple
way for applications to take actions based on a system- or user-specified
paper size.  This release is quite minimal, its purpose being to provide
really basic functions (obtaining the system paper name and getting
the height and width of a given kind of paper) that applications can
immediately integrate.

%package -n paper
Summary: Query paper size database and retrieve the preferred size
# The paper utility is licensed under GPL-3.0-or-later, and the paperconf is
# licensed under GPL-2.0-only.
License: GPL-3.0-or-later AND GPL-2.0-only
Group: Text tools
Requires: %name%soname = %EVR
# due to /usr/bin/paperconf
Conflicts: libpaper < 1.1.28-alt3

%description -n paper
This package enables users to indicate their preferred paper size, provides
the paper(1) utility to find the user's preferred default paper size and give
information about known sizes, and specifies system-wide and per-user paper
size catalogs, which can be can also be used directly (see paperspecs(5)).

The paper utility is licensed under GPL-3.0-or-later, and the paperconf utility
is licensed under GPL-2.0-only.

%package -n libpaper-devel
Summary: Header files for %name
# The library is licensed under LGPL-2.1-or-later.
License: LGPL-2.1-or-later
Group: Development/Other
Requires: %name%soname = %EVR

%description -n libpaper-devel
This package contains headers and libraries that programmers will need
to develop applications which use libpaper.

%prep
%setup

%build
%autoreconf
%configure --disable-static
%make_build

%install
%makeinstall_std
%find_lang libpaper

%set_verify_elf_method strict
%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1

%files -n libpaper%soname
%_docdir/libpaper/
%_docdir/libpaper/README
%_libdir/libpaper.so.*
%_sysconfdir/paperspecs
%_man5dir/paperspecs.5*

%files -n paper
%_bindir/paper
%_bindir/paperconf
%_man1dir/paper.1*

%files -n libpaper-devel
%_includedir/paper.h
%_libdir/libpaper.so

%changelog
