%def_disable snapshot

%define _name libpeas
%define ver_major 2.0
%define api_ver 2

%def_enable gjs
# not ready for lua-5.3
%def_disable lua
%def_enable introspection
%def_enable vala
%def_enable gtk_doc
%def_disable check
# no demo
%def_disable demo

Name: %_name%api_ver
Version: %ver_major.7
Release: alt1.1

Summary: A gobject-based plugins engine
Group: System/Libraries
License: LGPL-2.1-or-later
Url: https://wiki.gnome.org/Projects/Libpeas

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%_name/%ver_major/%_name-%version.tar.xz
%else
Source: %_name-%version.tar
%endif

BuildRequires(pre): rpm-macros-meson rpm-build-gir %{?_enable_vala:rpm-build-vala}
BuildRequires: meson gnome-common
BuildRequires: libgio-devel >= 2.74.0
# for python3 support
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel python3-module-pygobject3-devel >= 3.2.0
%{?_enable_introspection:BuildRequires: gobject-introspection-devel >= 1.39}
%{?_enable_gjs:BuildRequires: libgjs-devel >= 1.77.1 libmozjs128-devel gcc-c++}
%{?_enable_lua:BuildRequires: liblua5-devel luajit libluajit-devel lgi >= 0.9.0}
%{?_enable_vala:BuildRequires: vala-tools >= 0.14}
%{?_enable_gtk_doc:BuildRequires: gi-docgen}

%description
%name is a convenience library making adding plug-ins support
to GTK/GNOME and glib-based applications.

%package python3-loader
Summary: Python3 loader for %name
Group: System/Libraries
Requires: %name = %EVR

%description python3-loader
This package provides Python3 loader for %name.

%package gjs-loader
Summary: Javascript loader for %name
Group: System/Libraries
Requires: %name = %EVR

%description gjs-loader
This package provides GJS Javascript loader for %name.

%package lua-loader
Summary: LUA loader for %name
Group: System/Libraries
Requires: %name = %EVR

%description lua-loader
This package provides LUA-5.1 loader for %name.

%package devel
Summary: Development files for %name
Group: Development/C
Requires: %name = %EVR

%description devel
This package contains development libraries and header files
that are needed to write applications that use %name.

%package devel-doc
Summary: Development documentation for the %name
Group: Development/Documentation
Conflicts: %name < %version-%release
BuildArch: noarch

%description devel-doc
%name is a convenience library making adding plug-ins support
to GTK/GNOME and glib-based applications.

This package contains development documentation for the %name.

%package gir
Summary: GObject introspection data for the %name
Group: System/Libraries
Requires: %name = %EVR

%description gir
GObject introspection data for the %name.

%package gir-devel
Summary: GObject introspection devel data for the %name
Group: Development/Other
BuildArch: noarch
Requires: %name-devel = %EVR
Requires: %name-gir = %EVR

%description gir-devel
GObject introspection devel data for the %name.

%package demo
Summary: %name demonstration program
Group: Development/C
Requires: %name = %EVR
Requires: %name-gir = %EVR

%description demo
%name is a convenience library making adding plug-ins support
to GTK/GNOME and glib-based applications.

This package contains %name demonstration programs.

%prep
%setup -n %_name-%version

%build
%meson \
    %{subst_enable_meson_bool gtk_doc gtk_doc} \
    %{subst_enable_meson_bool gjs gjs} \
    %{subst_enable_meson_bool lua lua51} \
    %{subst_enable_meson_bool vala vapi} \
    %{subst_enable_meson_bool introspection introspection}
%nil
%meson_build

%install
%meson_install
%find_lang --output=%name.lang %_name-%api_ver

%check
#xvfb-run
%__meson_test


%files -f %name.lang
%_libdir/%{_name}*-%api_ver.so.*
%dir %_libdir/%_name-%api_ver/loaders
#%_datadir/icons/hicolor/*/*/*
%doc README*

%files python3-loader
%_libdir/%_name-%api_ver/loaders/libpythonloader.so

%if_enabled gjs
%files gjs-loader
%_libdir/%_name-%api_ver/loaders/libgjsloader.so
%endif

%if_enabled lua
%files lua-loader
%_libdir/%_name-%api_ver/loaders/liblua*loader.so
%endif

%files devel
%_libdir/%{_name}*-%api_ver.so
%_includedir/%_name-%api_ver/
%_pkgconfigdir/%_name-%api_ver.pc
%{?_enable_vala:
%_vapidir/%_name-%api_ver.deps
%_vapidir/%_name-%api_ver.vapi}

%if_enabled gtk_doc
%files devel-doc
%_datadir/doc/%_name-%api_ver
%endif

%if_enabled introspection
%files gir
%_typelibdir/Peas-%api_ver.typelib

%files gir-devel
%_girdir/Peas-%api_ver.gir
%endif

%if_enabled demo
%files demo
%_bindir/peas-demo
%add_python3_path %_libdir/peas-demo
%_libdir/peas-demo/
%endif


%changelog
