%define _unpackaged_files_terminate_build 1

%def_with curl
%def_with gnome
%def_with kde
%def_with env
%def_with sysconfig
%def_without duktape

Name: libproxy
Version: 0.5.6
Release: alt1
Summary: A library that provides automatic proxy configuration management

Group: System/Libraries
License:  GPL-2.0-or-later AND LGPL-2.1-or-later
Url: http://libproxy.github.io/libproxy
Vcs: https://github.com/libproxy/libproxy.git
Source: %name-%version.tar
Patch: %name-%version-%release.patch

BuildRequires(pre): rpm-macros-meson 
BuildRequires: meson >= 0.59.0 rpm-build-vala vala-tools rpm-build-gir
BuildRequires: pkgconfig(glib-2.0) >= 2.71.3 pkgconfig(gio-2.0) >= 2.71.3 pkgconfig(gobject-2.0)
BuildRequires: pkgconfig(gobject-introspection-1.0) /usr/bin/g-ir-scanner gir(Gio) = 2.0
BuildRequires: gi-docgen
%{?_with_curl:BuildRequires: pkgconfig(libcurl)}
%{?_with_gnome:BuildRequires: pkgconfig(gsettings-desktop-schemas)}
%{?_with_duktape:BuildRequires: pkgconfig(duktape)}

Provides: %name-gnome = %EVR
Obsoletes: %name-gnome < 0.5.0
Provides: %name-gnome3 = %EVR
Obsoletes: %name-gnome3 < 0.5.0
Provides: %name-kde = %EVR
Obsoletes: %name-kde < 0.5.0
Provides: %name-kde4 = %EVR
Obsoletes: %name-kde4 < 0.5.0
Provides: %name-mozjs = %EVR
Obsoletes: %name-mozjs < 0.5.0
Provides: %name-webkit = %EVR
Obsoletes: %name-webkit < 0.5.0
Provides: %name-networkmanager = %EVR
Obsoletes: %name-networkmanager < 0.5.0

%description
libproxy is a library that provides automatic proxy configuration management.

libproxy offers the following features:
- support for all major platforms: Windows, Mac and Linux/UNIX
- extremely small core footprint
- minimal dependencies within libproxy core
- only 4 functions in the stable-ish external API
- dynamic adjustment to changing network topology
- a standard way of dealing with proxy settings across all scenarios
- a sublime sense of joy and accomplishment

%package tools
Summary: A sample & test application to test what libproxy will reply
Group: Networking/Other
Requires: %name = %version-%release

%description tools
A simple application that will use libproxy to give the results you can expect from.
other applications. Great to debug what would happen.

%package gir
Summary: GObject introspection data for the %name library
Group: System/Libraries
Requires: %name = %version-%release

%description gir
GObject introspection data for the %name library.

%package devel
Summary: Development files for %name
Group: Development/C
Requires: %name = %version-%release

%description devel
The %name-devel package contains libraries and header files for
developing applications that use %name.

%package devel-doc
Summary: Development docs package for %name libraries
Group: Development/Documentation
BuildArch: noarch
Conflicts: %name < %version

%description devel-doc
Development docs package for %name libraries.

%prep
%setup -q
%patch -p1

%build
%meson \
    -Drelease=true \
    %{?_without_curl:-Dcurl=false} \
    %{?_without_gnome:-Dconfig-gnome=false} \
    %{?_without_kde:-Dconfig-kde=false} \
    %{?_without_env:-Dconfig-env=false} \
    %{?_without_sysconfig:-Dconfig-sysconfig=false} \
    %{?_without_duktape:-Dpacrunner-duktape=false} \
    -Dconfig-xdp=true \
    -Dconfig-windows=false \
    -Dconfig-osx=false

%meson_build

%install
%meson_install

%check
%meson_test

%files
%doc README.md
%_libdir/*.so.*
%_libdir/%name

%files tools
%_bindir/proxy
%_man8dir/proxy.*

%files gir
%_typelibdir/*.typelib

%files devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*.pc
%_girdir/*.gir
%_vapidir/libproxy-1.0.*

%files devel-doc
%_defaultdocdir/libproxy-1.0

%changelog
