# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/fep /usr/bin/valadoc pkgconfig(gio-2.0)
# END SourceDeps(oneline)
Group: System/Libraries
%add_optflags %optflags_shared
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:		libskk
Version:	1.0.4
Release:	alt3_11
Summary:	Library to deal with Japanese kana-to-kanji conversion method

License:	GPLv3+
URL:		http://github.com/ueno/libskk
Source0:	https://bitbucket.org/libskk/libskk/downloads/%{name}-%{version}.tar.xz

BuildRequires(pre): rpm-macros-valgrind
BuildRequires:	vala vala-tools valadoc-devel
BuildRequires:	pkgconfig(gee-0.8)
BuildRequires:	libjson-glib libjson-glib-devel libjson-glib-gir-devel
BuildRequires:	gobject-introspection-devel
BuildRequires:	gettext-tools libasprintf-devel
%ifarch %valgrind_arches
BuildRequires: /usr/bin/valgrind
%endif
Source44: import.info

%description
The libskk project aims to provide GObject-based interface of Japanese
input methods.  Currently it supports SKK (Simple Kana Kanji) with
various typing rules including romaji-to-kana, AZIK, ACT, TUT-Code,
T-Code, and NICOLA.


%package	devel
Group: Development/Other
Summary:	Development files for %{name}
Requires:	%{name} = %{version}-%{release}

%description	devel
The %{name}-devel package contains libraries and header files for
developing applications that use %{name}.


%package        tools
Group: Development/Tools
Summary:	Tools for %{name}
BuildRequires:	libfep-devel
Requires:	%{name} = %{version}-%{release}

%description	tools
The %{name}-tools package contains tools for developing applications
that use %{name}.


%prep
%setup -q


%build
%configure --disable-static --enable-fep
sed -i 's|^hardcode_libdir_flag_spec=.*|hardcode_libdir_flag_spec=""|g' libtool
sed -i 's|^runpath_var=LD_RUN_PATH|runpath_var=DIE_RPATH_DIE|g' libtool
%make_build


%install
make install DESTDIR=$RPM_BUILD_ROOT INSTALL="install -p"
find $RPM_BUILD_ROOT -name '*.la' -exec rm -f {} ';'

%find_lang %{name}





%files -f %{name}.lang
%doc README rules/README.rules COPYING
%{_libdir}/*.so.*
%{_datadir}/libskk
%{_libdir}/girepository-1.0/Skk*.typelib

%files devel
%{_includedir}/*
%{_libdir}/*.so
%{_libdir}/pkgconfig/*.pc
%{_datadir}/gir-1.0/Skk*.gir
%{_datadir}/vala/vapi/*

%files tools
%{_bindir}/skk*
%{_libexecdir}/skk*
%{_mandir}/man1/skk*


%changelog
