%define _unpackaged_files_terminate_build 1

%def_without jbig
%define soname 6

Name: libtiff
Version: 4.7.1
Release: alt1

Summary: Library of functions for manipulating TIFF format image files
License: libtiff
Group: System/Libraries
Url: https://libtiff.gitlab.io/libtiff/
VCS: https://gitlab.com/libtiff/libtiff.git

Source: %name-%version.tar

%def_enable cxx

BuildRequires: gcc-c++
BuildRequires: libSM-devel
BuildRequires: libXi-devel
BuildRequires: libXmu-devel
BuildRequires: libdeflate-devel
BuildRequires: libfreeglut-devel
BuildRequires: libjpeg-devel
BuildRequires: liblzma-devel
BuildRequires: libwebp-devel
BuildRequires: libzstd-devel
BuildRequires: zlib-devel
BuildRequires: python3-module-sphinx

%if_with jbig
BuildRequires: libjbig-devel
%else
BuildConflicts: libjbig-devel
%endif

%description
This package contains a library of functions for manipulating
TIFF (Tagged Image File Format) image format files.  TIFF is a widely
used file format for bitmapped images.  TIFF files usually end in the
.tif extension and they are often quite large.

%package -n libtiff%soname
Summary: Library of functions for manipulating TIFF format image files
Group: System/Libraries

%package utils
Summary: Programs for manipulating TIFF format image files
Group: Graphics
Requires: libtiff%soname = %version-%release

%package -n tiffgt
Summary: Program for viewing TIFF format image files
Group: Graphics
Requires: libtiff%soname = %version-%release

%package devel
Summary: Development files for programs which will use the tiff library
Group: Development/C
Requires: libtiff%soname = %version-%release
Provides: libtiff%soname-devel
Obsoletes: libtiff%soname-devel

%package doc
Summary: Documentation files for programs which will use the tiff library
Group: Development/C
BuildArch: noarch

%package -n libtiffxx%soname
Summary: TIFF I/O C++ shared library
Group: System/Libraries
Requires: libtiff%soname = %version-%release

%package -n libtiffxx-devel
Summary: TIFF I/O C++ development library and header files
Group: Development/C
Requires: libtiffxx%soname = %version-%release

%description -n libtiff%soname
This package contains a library of functions for manipulating
TIFF (Tagged Image File Format) image format files.  TIFF is a widely
used file format for bitmapped images.  TIFF files usually end in the
.tif extension and they are often quite large.

%description utils
This package contains simple client programs for accessing
the tiff functions.

%description doc
This package contains documentation files for developing programs which
will manipulate TIFF format image files using the tiff library.

%description -n tiffgt
This package contains tiffgt - a TIFF file display program.

%description devel
This package contains the header files for developing programs which
will manipulate TIFF format image files using the tiff library.

%description -n libtiffxx%soname
This package contains TIFF I/O C++ shared library

%description -n libtiffxx-devel
This package contains TIFF I/O C++ development library and header files.

%prep
%setup
%autopatch -p1
rm -f libtool.m4

libtoolize --force --copy
aclocal -I . -I m4
touch config/config.h.in
automake --add-missing --copy
autoconf
autoheader

%build
%add_optflags -Wl,--no-undefined
%autoreconf
%configure \
  --prefix=%_prefix \
  --enable-ld-version-script \
  --enable-static=no \
  %{subst_enable cxx} \
  #

%make_build X_PRE_LIBS= GLUT_CFLAGS= GLUT_CFLAGS= GLUT_LIBS='-lglut -lGL' \
	GLU_CFLAGS= GLU_LIBS= GL_CFLAGS= GL_LIBS=

%install
%makeinstall_std

%check
%make_build -k check

%files doc
%dir %_datadir/doc/tiff-%version
%_datadir/doc/tiff-%version/

%files -n libtiff%soname
%_libdir/libtiff.so.%{soname}*

%files utils
%_bindir/*
%_man1dir/*.*
%exclude %_bindir/tiffgt
%exclude %_man1dir/tiffgt.*

%files -n tiffgt
%_bindir/tiffgt
%_man1dir/tiffgt.*

%files devel
%_pkgconfigdir/*.pc
%_libdir/libtiff.so
%_includedir/*.h
%_man3dir/*.*

%if_enabled cxx
%files -n libtiffxx%soname
%_libdir/libtiffxx.so.%{soname}*

%files -n libtiffxx-devel
%_libdir/libtiffxx.so
%_includedir/*.hxx
%endif

%changelog
