%def_without jbig

Name: libtiff5
Version: 4.4.0
Release: alt9

Summary: Library of functions for manipulating TIFF format image files
License: libtiff
Group: System/Libraries
Url: https://libtiff.gitlab.io/libtiff/
VCS: https://gitlab.com/libtiff/libtiff.git

# git://git.altlinux.org/gears/l/%name
Source: %name-%version-%release.tar
Patch0: libtiff-4.4.0-fedora-cve-2024-7006.patch
Patch1: libtiff-4.4.0-upstream-cve-2023-52356.patch
Patch2: libtiff-4.4.0-upstream-cve-2023-6228.patch
Patch3: libtiff-4.4.0-upstream-cve-2022-40090.patch
Patch4: libtiff-4.4.0-debian-cve-2023-0795-0796-0797-0798-0799.patch
Patch5: libtiff-4.4.0-debian-cve-2023-0800-0801-0802-0803-0804.patch
Patch6: libtiff-4.4.0-upstream-cve-2023-1916.patch
Patch7: libtiff-4.4.0-ubuntu-cve-2023-25433.patch
Patch8: libtiff-4.4.0-upstream-cve-2023-26966.patch
Patch9: libtiff-4.4.0-upstream-cve-2023-2731.patch
Patch10: libtiff-4.4.0-upstream-cve-2023-2908.patch
Patch11: libtiff-4.4.0-upstream-cve-2023-3316.patch
Patch12: libtiff-4.4.0-upstream-cve-2023-3576.patch
Patch13: libtiff-4.4.0-upstream-cve-2023-3618.patch
Patch14: libtiff-4.4.0-upstream-cve-2023-41175.patch
Patch15: libtiff-4.4.0-ubuntu-cve-2023-6277-1.patch
Patch16: libtiff-4.4.0-ubuntu-cve-2023-6277-2.patch
Patch17: libtiff-4.4.0-ubuntu-cve-2023-6277-3.patch
Patch18: libtiff-4.4.0-ubuntu-cve-2023-6277-4.patch
Patch19: libtiff-4.4.0-debian-cve-2022-48281.patch
Patch20: libtiff-4.4.0-ubuntu-cve-2023-40745.patch
Patch21: libtiff-4.4.0-ubuntu-cve-2023-26965.patch
Patch22: libtiff-4.4.0-upstream-cve-2025-8176.patch
Patch23: libtiff-4.4.0-upstream-cve-2025-8177.patch
Patch24: libtiff-4.4.0-upstream-cve-2025-8534.patch
Patch25: libtiff-4.4.0-upstream-cve-2024-13978.patch
Patch26: libtiff-4.4.0-upstream-cve-2025-8851.patch
Patch27: libtiff-4.4.0-upstream-cve-2025-9165.patch
Patch28: libtiff-4.4.0-upstream-cve-2025-8961.patch
Patch29: libtiff-4.4.0-upstream-cve-2025-9900.patch

%def_disable static
%def_enable cxx

BuildRequires: gcc-c++ libSM-devel libXi-devel libXmu-devel libfreeglut-devel libjpeg-devel liblzma-devel libwebp-devel libzstd-devel zlib-devel

%if_with jbig
BuildRequires: libjbig-devel
%else
BuildConflicts: libjbig-devel
%endif

%description
This package contains a library of functions for manipulating
TIFF (Tagged Image File Format) image format files.  TIFF is a widely
used file format for bitmapped images.  TIFF files usually end in the
.tif extension and they are often quite large.

%prep
%setup -n %name-%version-%release
%autopatch -p1
:>port/dummy.c

cd libtiff
cat > libtiff.sym << EOF
TIFFFaxBlackCodes
TIFFFaxBlackTable
TIFFFaxMainTable
TIFFFaxWhiteCodes
TIFFFaxWhiteTable
_TIFFCheckMalloc
_TIFFFax3fillruns
_TIFFMultiply32
_TIFFRewriteField
_TIFFGetExifFields
_TIFFClampDoubleToFloat
_TIFFFillStriles
TIFFFlushData1
_TIFFGetFields
_TIFFMergeFields
_TIFFSeekOK
_TIFFClampDoubleToUInt32
TIFFSetCompressionScheme
_TIFFgetMode
display_sRGB
EOF
sed -n 's/^extern[^)]\+[[:space:]]\*\?\([^[:space:]*()]\+\)[[:space:]]*(.*/\1/p' \
	tiffio.h >> libtiff.sym
sort -u -o libtiff.sym{,}
cat > libtiff.map << EOF
{
 global:
$(sed 's/.*/  &;/' libtiff.sym)
 local:
  *;
};
EOF
rm libtiff.sym

%build
%autoreconf
%define docdir %_docdir/%name-%version
%configure --with-docdir=%docdir --enable-ld-version-script \
	%{subst_enable static} %{subst_enable cxx}
%make_build X_PRE_LIBS= GLUT_CFLAGS= GLUT_CFLAGS= GLUT_LIBS='-lglut -lGL' \
	GLU_CFLAGS= GLU_LIBS= GL_CFLAGS= GL_LIBS=

%install
%makeinstall_std
xz -9 %buildroot%docdir/ChangeLog

%check
%make_build -k check

rm -rv %buildroot{%_bindir,%_mandir,%_pkgconfigdir,%_libdir/*.so,%_includedir,%docdir/html,%_libdir/libtiffxx.so.*}

%files
%_libdir/libtiff.so.5
%_libdir/libtiff.so.5.*
%dir %docdir
%docdir/[A-Z]*

%changelog
