%def_disable snapshot
%define _name umockdev
%define namespace UMockdev
%define api_ver 1.0

%def_enable gtk_doc
# /sys/devices/ required
%def_disable check

Name: lib%_name
Version: 0.19.3
Release: alt1

Summary: Hardware devices mocking library for creating unit tests and bug reporting
Group: System/Libraries
License: LGPL-2.1-or-later
Url: https://launchpad.net/%_name

%if_disabled snapshot
Source: https://github.com/martinpitt/%_name/releases/download/%version/%_name-%version.tar.xz
%else
Vcs: https://github.com/martinpitt/umockdev.git
Source: %_name-%version.tar
%endif

%define glib_ver 2.32

BuildRequires(pre): rpm-macros-meson rpm-build-gir rpm-build-vala
BuildRequires: meson vala-tools
BuildRequires: libgio-devel >= %glib_ver
BuildRequires: libudev-devel libgudev-devel
BuildRequires: libpcap-devel
BuildRequires: gobject-introspection-devel

%{?_enable_gtk_doc:BuildRequires: gtk-doc}
%{?_enable_check:
BuildRequires: /proc /dev/pts udev valgrind
BuildRequires: python3-module-pygobject3 libgudev-gir-devel
BuildRequires: xorg-server xorg-drv-dummy gphoto2 evtest xinput}

%description
umockdev mocks Linux devices for creating integration tests for hardware
related libraries and programs. It also provides tools to record the properties
and behaviour of particular devices, and to run a program or test suite under
a test bed with the previously recorded devices loaded. This allows
developers of software like gphoto or libmtp to receive these records in bug
reports and recreate the problem on their system without having access to the
affected hardware.

%package devel
Summary: Development files for %name
Group: Development/C
Requires: /proc
Requires: %name = %version-%release

%description devel
This package contains libraries, header files and documentation for
developing applications that use %name.

%package devel-doc
Summary: Development documentation for %_name
Group: Development/Documentation
Conflicts: %name < %version-%release
BuildArch: noarch

%description devel-doc
This package contains development documentation for %_name.

%package gir
Summary: GObject introspection data for the %name
Group: System/Libraries
Requires: %name = %version-%release

%description gir
GObject introspection data for the %_name library.

%package gir-devel
Summary: GObject introspection devel data for the %name
Group: Development/Other
BuildArch: noarch
Requires: %name-gir = %version-%release
Requires: %name-devel = %version-%release

%description gir-devel
GObject introspection devel data for the %_name library.

%define pkg_docdir %_defaultdocdir/%name-%version

%prep
%setup -n %_name-%version

%build
%meson \
%{subst_enable_meson_bool gtk_doc gtk_doc}
%nil
%meson_build

%install
%meson_install
install -pD -m644 NEWS %buildroot%pkg_docdir

%check
export PATH=/sbin:$PATH
%__meson_test

%files
%_bindir/%_name-record
%_bindir/%_name-run
%_bindir/%_name-wrapper
%_libdir/%name.so.*
%_libdir/%name-preload.so.*
%doc %pkg_docdir

%files devel
%_includedir/%_name-%api_ver/
%_libdir/%name.so
%_libdir/%name-preload.so
%_pkgconfigdir/%_name-%api_ver.pc
%_vapidir/%_name-%api_ver.vapi

%if_enabled gtk_doc
%files devel-doc
%_datadir/gtk-doc/html/%_name/
%endif

%files gir
%_typelibdir/%namespace-%api_ver.typelib

%files gir-devel
%_girdir/%namespace-%api_ver.gir

%changelog
