%define soversion 12

Name: libwlroots
Version: 0.17.3
Release: alt1

Summary: Modular Wayland compositor library
License: MIT
Group: System/Libraries
Url: https://gitlab.freedesktop.org/wlroots/wlroots

%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1

# Source-url: https://gitlab.freedesktop.org/wlroots/wlroots/-/releases/%version/downloads/wlroots-%version.tar.gz
Source: %name-%version.tar

BuildRequires(pre): meson
BuildRequires: cmake
BuildRequires: ctags
BuildRequires: glslang
BuildRequires: pkgconfig(hwdata)

BuildRequires: pkgconfig(egl)
BuildRequires: pkgconfig(freerdp2)
BuildRequires: pkgconfig(gbm)
BuildRequires: pkgconfig(glesv2)
BuildRequires: pkgconfig(libavcodec)
BuildRequires: pkgconfig(libavformat)
BuildRequires: pkgconfig(libavutil)
BuildRequires: pkgconfig(libdrm)
BuildRequires: pkgconfig(libdisplay-info)
BuildRequires: pkgconfig(libinput)
BuildRequires: pkgconfig(libpng)
BuildRequires: pkgconfig(libseat)
BuildRequires: pkgconfig(libudev)
BuildRequires: pkgconfig(pixman-1)
BuildRequires: pkgconfig(vulkan)
BuildRequires: pkgconfig(wayland-client)
BuildRequires: pkgconfig(wayland-cursor)
BuildRequires: pkgconfig(wayland-egl)
BuildRequires: pkgconfig(wayland-protocols)
BuildRequires: pkgconfig(wayland-scanner)
BuildRequires: pkgconfig(wayland-server)
BuildRequires: pkgconfig(x11-xcb)
BuildRequires: pkgconfig(xcb)
BuildRequires: pkgconfig(xcb-composite)
BuildRequires: pkgconfig(xcb-icccm)
BuildRequires: pkgconfig(xcb-render)
BuildRequires: pkgconfig(xcb-renderutil)
BuildRequires: pkgconfig(xcb-xfixes)
BuildRequires: pkgconfig(xcb-xinput)
BuildRequires: pkgconfig(xcb-errors)

BuildRequires: pkgconfig(xkbcommon)
BuildRequires: pkgconfig(xwayland)

%description
%summary.

%package -n libwlroots%soversion
Summary: Modular Wayland compositor library
Group: System/Libraries

%description -n libwlroots%soversion
%summary.

%package -n libwlroots-devel
Summary: Development files for libwlroots
Group: Development/C
Requires: libwlroots%soversion = %EVR

%description -n libwlroots-devel
This package provides development files for libwlroots library.

%prep
%setup

if ! grep -qs '^soversion[[:space:]]*=[[:space:]]*%soversion[[:space:]]*$' meson.build; then
	echo >&2 "Outdated %%soversion value in spec"
	exit 1
fi

%build
%meson \
  "-Dbackends=[
    'drm',
	'libinput',
    'x11',
  ]" \
  -Dxwayland=enabled \
  -Dxcb-errors=enabled

%meson_build

%install
%meson_install

%check
export LD_LIBRARY_PATH=%buildroot%_libdir
%meson_test

%files -n libwlroots%soversion
%_libdir/libwlroots.so.*
%doc README.md LICENSE

%files -n libwlroots-devel
%_includedir/wlr
%_libdir/libwlroots.so
%_pkgconfigdir/wlroots.pc

%changelog
