%def_enable introspection
%def_enable vala
%def_enable glibtop

%if_disabled glibtop
%def_disable epoxy
%def_disable gudev
%else
%def_enable epoxy
%def_enable gudev
%endif

%def_disable gladeui2

%def_disable docs

Name: libxfce4ui
Version: 4.20.2
Release: alt1

Summary: Various GTK widgets for Xfce
Summary (ru_RU.UTF-8): Набор виджетов GTK для Xfce
License: LGPLv2+
Group: Graphical desktop/XFce
Url: https://docs.xfce.org/xfce/libxfce4ui/start

Packager: Xfce Team <xfce@packages.altlinux.org>

Vcs: https://gitlab.xfce.org/xfce/libxfce4ui.git
Source: %name-%version.tar
Patch: %name-%version-%release.patch

BuildPreReq: rpm-build-xfce4 xfce4-dev-tools
BuildRequires: libxfce4util-devel >= 4.17.2-alt1 libxfconf-devel
BuildRequires: libX11-devel libICE-devel libSM-devel libstartup-notification-devel
BuildRequires: libgtk+3-devel
%{?_enable_gladeui2:BuildRequires: libgladeui2.0-devel}
%{?_enable_glibtop:BuildRequires: libgtop-devel}
%{?_enable_gudev:BuildRequires: libgudev-devel}
%{?_enable_epoxy:BuildRequires: libepoxy-devel}
%{?_enable_introspection:BuildRequires: gobject-introspection-devel libgtk+3-gir-devel libxfce4util-gir-devel}
%{?_enable_vala:BuildRequires: vala-tools libxfce4util-vala}
# NOTE: gtk-doc is required by build system even if docs are disabled.
BuildRequires: gtk-doc

Requires: %name-common = %version-%release

%define libxfce4kbd_name_gtk3 libxfce4kbd-private-3
%define libxfce4ui_name_gtk3 %name-2

%define _unpackaged_files_terminate_build 1

%description
Various GTK widgets for Xfce.

%description -l ru_RU.UTF-8
Набор виджетов GTK для Xfce.

%if_enabled docs
%package devel-doc
Summary: Development documentation for %name
Group: Development/Documentation
BuildArch: noarch
Conflicts: %name-devel < %version-%release

%description devel-doc
This package contains development documentation for %name.
%endif

%package common
Summary: Common files for %name
Group: Graphical desktop/XFce
BuildArch: noarch
Requires: xfce4-common

%description common
This package contains the common files for %name.

%package gtk3
Summary: Various GTK+3 widgets for Xfce
Group: Graphical desktop/XFce
Requires: %name-common = %version-%release

%description gtk3
Various GTK+3 widgets for Xfce.

%package gtk3-devel
Summary: Development files for %name (GTK+3)
Group: Development/C
Requires: %name-gtk3 = %version-%release

%description gtk3-devel
Development files for the %name library (GTK+3 variant).

%if_enabled introspection
%package gtk3-gir
Summary: GObject introspection data for %name-gtk3
Group: System/Libraries
Requires: %name-gtk3 = %EVR

%description gtk3-gir
GObject introspection data for %name-gtk3.

%package gtk3-gir-devel
Summary: GObject introspection devel data for %name-gtk3
Group: System/Libraries
BuildArch: noarch
Requires: %name-gtk3-gir = %EVR
Requires: %name-gtk3-devel = %EVR

%description gtk3-gir-devel
GObject introspection devel data for %name-gtk3.
%endif

%if_enabled vala
%package gtk3-vala
Summary: Vala bindings for %name-gtk3
Group: System/Libraries
Requires: %name-gtk3-devel = %EVR
BuildArch: noarch

%description gtk3-vala
Vala bindings for %name-gtk3.
%endif

%package -n xfce4-about
Summary: Xfce4 'About' dialog
Group: Graphical desktop/XFce
# Due to xfce4-about
Conflicts: xfce-utils < 4.8.3-alt3

%description -n xfce4-about
This package contains the 'About Xfce' dialog.

%prep
%setup
%patch -p1

%build
%xfce4reconf
%configure \
	--disable-static \
	--enable-maintainer-mode \
	--enable-x11 \
	--enable-wayland \
	--enable-startup-notification \
	%{subst_enable gladeui2} \
	%{subst_enable glibtop} \
	%{subst_enable gudev} \
	%{subst_enable epoxy} \
	%{subst_enable introspection} \
	%{subst_enable vala} \
	--enable-tests \
%if_enabled docs
	--enable-gtk-doc \
%else
	--disable-gtk-doc \
%endif
	--enable-debug=minimum
%make_build

%install
%makeinstall_std
%find_lang %name

%check
make check

%if_enabled docs
%files devel-doc
%doc %_datadir/gtk-doc/html/%name
%endif

%files common -f %name.lang
%doc README.md NEWS AUTHORS
%_iconsdir/hicolor/*/apps/*
%config(noreplace) %_sysconfdir/xdg/xfce4/xfconf/xfce-perchannel-xml/*.xml

%files gtk3
%_libdir/%libxfce4kbd_name_gtk3.so.*
%_libdir/%libxfce4ui_name_gtk3.so.*

%files gtk3-devel
%_includedir/xfce4/%libxfce4kbd_name_gtk3
%_includedir/xfce4/%libxfce4ui_name_gtk3
%_pkgconfigdir/%libxfce4kbd_name_gtk3.pc
%_pkgconfigdir/%libxfce4ui_name_gtk3.pc
%_libdir/%libxfce4kbd_name_gtk3.so
%_libdir/%libxfce4ui_name_gtk3.so

%if_enabled gladeui2
%_datadir/glade/catalogs/*.xml
%_datadir/glade/pixmaps/*/*/*/*
%_libdir/glade/modules/*.so
%exclude %_libdir/glade/modules/*.la
%endif

%if_enabled introspection
%files gtk3-gir
%_libdir/girepository-1.0/*.typelib

%files gtk3-gir-devel
%_datadir/gir-1.0/*.gir
%endif

%if_enabled vala
%files gtk3-vala
%_datadir/vala/vapi/%name-*
%endif

%files -n xfce4-about
%_bindir/xfce4-about
%_desktopdir/xfce4-about.desktop

%changelog
