Name: libxlsxwriter
Version: 1.1.7
Release: alt1
Summary: A C library for creating Excel XLSX files
Group: Development/C
Packager: Ilya Mashkin <oddity@altlinux.ru>
# BSD: Most files
# Public Domain: third_party/md5/*
# MPL: third_party/tmpfileplus/*
License: BSD and Public Domain and MPLv2.0
Url: https://github.com/jmcnamara/libxlsxwriter/
Source0: https://github.com/jmcnamara/libxlsxwriter/archive/RELEASE_%version/%name-%version.tar.gz

BuildRequires: cmake
BuildRequires: make
BuildRequires: gcc-c++
BuildRequires: libminizip-devel
BuildRequires: zlib-devel
BuildRequires: python3-module-pytest

%description
Libxlsxwriter is a C library that can be used to write text, numbers, formulas
and hyperlinks to multiple worksheets in an Excel 2007+ XLSX file.

%package devel
Summary: Development files for %name
Requires: %name%{?_isa} = %version-%release
Group: Development/C

%description devel
The %name-devel package contains libraries and header files for
developing applications that use %name.

%prep
%setup -n %name-RELEASE_%version

%__subst 's|ZLIB REQUIRED "1.0"|ZLIB|' CMakeLists.txt

# Delete bundled minizip
rm -rf third_party/minizip
rm -f include/xlsxwriter/third_party/zip.h

%build
%{?optflags_lto:%global optflags_lto %optflags_lto -ffat-lto-objects}
%cmake -DUSE_SYSTEM_MINIZIP=ON -DBUILD_TESTS=ON -DBUILD_SHARED_LIBS=ON
%cmake_build

%install
%cmake_install

%files
%doc Readme.md Changes.txt License.txt
%_libdir/%name.so.6*

%files devel
%_includedir/xlsxwriter.h
%_includedir/xlsxwriter/
%_libdir/%name.so
%_libdir/pkgconfig/xlsxwriter.pc

%changelog
