%define _unpackaged_files_terminate_build 1
%set_verify_elf_method strict

Name: libxml2
Version: 2.12.10
Release: alt2
Epoch: 1

Summary: The library for manipulating XML files
License: MIT
Group: System/Libraries
Url: https://gitlab.gnome.org/GNOME/libxml2
Vcs: https://gitlab.gnome.org/GNOME/libxml2.git

%def_with python2
%def_disable static
%define srcname %name-%version

Source: %srcname.tar
# https://www.w3.org/XML/Test/xmlts20130923.tar.gz
Source1: xmlts.tar
Patch: %name-%version-%release.patch

Requires: xml-common

BuildRequires: liblzma-devel zlib-devel

%if_with python2
BuildRequires(pre): rpm-build-python
BuildRequires: python-devel python-module-setuptools
%endif

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel python3-module-setuptools

%package devel
Summary: Development environment for building applications manipulating XML files
Group: Development/C
Requires: %name = %EVR

%package devel-static
Summary: Static library for building applications manipulating XML files
Group: Development/C
Requires: %name-devel = %EVR

%package -n xml-utils
Summary: Various XML utilities
Group: Text tools
Requires: %name = %EVR
Provides: xmllint = %epoch:%version
Obsoletes: xmllint < %epoch:%version

%package -n python-module-%name
Summary: Python bindings for the %name library
Group: Development/Python
Requires: %name = %EVR
Provides: libxml2-python = %epoch:%version, python-modules-%name = %epoch:%version
Obsoletes: libxml2-python < %epoch:%version, python-modules-%name < %epoch:%version

%package -n python3-module-%name
Summary: Python3 bindings for the %name library
Group: Development/Python3
Requires: %name = %EVR

%package doc
Summary: Documentation for the %name library
Group: Development/C
Conflicts: %name < %epoch:%version, %name > %epoch:%version
BuildArch: noarch

%description
This library allows to manipulate XML files.  It includes support
to read, modify and write XML and HTML files.  There is DTDs support
this includes parsing and validation even with complex DtDs, either
at parse time or later once the document has been modified.  The output
can be a simple SAX stream or and in-memory DOM like representations.
In this case one can use the built-in XPath and XPointer implementation
to select subnodes or ranges.  A flexible Input/Output mechanism is
available, with existing HTTP and FTP modules and combined to an
URI library.

This package contains the shared library required to run
applications manipulating XML files.

%description devel
This library allows to manipulate XML files.  It includes support
to read, modify and write XML and HTML files.  There is DTDs support
this includes parsing and validation even with complex DtDs, either
at parse time or later once the document has been modified.  The output
can be a simple SAX stream or and in-memory DOM like representations.
In this case one can use the built-in XPath and XPointer implementation
to select subnodes or ranges.  A flexible Input/Output mechanism is
available, with existing HTTP and FTP modules and combined to an
URI library.

This package contains the libraries, include and other files
you can use to develop applications manipulating XML files.

%description devel-static
This library allows to manipulate XML files.  It includes support
to read, modify and write XML and HTML files.  There is DTDs support
this includes parsing and validation even with complex DtDs, either
at parse time or later once the document has been modified.  The output
can be a simple SAX stream or and in-memory DOM like representations.
In this case one can use the built-in XPath and XPointer implementation
to select subnodes or ranges.  A flexible Input/Output mechanism is
available, with existing HTTP and FTP modules and combined to an
URI library.

This package contains the static library you can use to develop
statically linked applications manipulating XML files.

%description -n xml-utils
This package contains xml tools:
+ xmllint - utility for parsing and validating XML files;
+ xmlcatalog - command line tool to parse and manipulate XML or SGML
catalog files.

%description -n python-module-%name
This package contains a module that permits applications
written in the Python programming language to use the interface
supplied by the %name library to manipulate XML files.

This library allows to manipulate XML files.  It includes support
to read, modify and write XML and HTML files.  There is DTDs support
this includes parsing and validation even with complex DTDs, either
at parse time or later once the document has been modified.

%description -n python3-module-%name
This package contains a module that permits applications
written in the Python3 programming language to use the interface
supplied by the %name library to manipulate XML files.

This library allows to manipulate XML files.  It includes support
to read, modify and write XML and HTML files.  There is DTDs support
this includes parsing and validation even with complex DTDs, either
at parse time or later once the document has been modified.

%description doc
This package contains documentation on the XML C library.

%prep
%setup -n %srcname -a1
%patch -p1

%build
export ac_cv_path_WGET=/usr/bin/wget
export ac_cv_path_XMLLINT=/usr/bin/xmllint
export ac_cv_path_XSLTPROC=/usr/bin/xsltproc
# disable dependency on binutils-devel
export ac_cv_header_ansidecl_h=no
mkdir -p m4
%autoreconf
mkdir build
pushd build
ln -s ../xmlconf
mkdir -p fuzz
%define _configure_script ../configure
export PYTHON="%__python3"
%configure \
    --with-python \
    %{subst_enable static} \
    --disable-silent-rules
%make_build DOC_MODULE=%name-%version
popd
%if_with python2
mkdir python2
pushd python2
export PYTHON="%__python"
%configure \
	--with-python \
	--disable-static \
	--disable-silent-rules
cp -la ../build/{*.la,.libs} .
%make_build -C python
popd
%endif

%check
%make_build DOC_MODULE=%name-%version -k check -C build

%install
%makeinstall_std DOC_MODULE=%name-%version -C build
%if_with python2
%makeinstall_std -C python2/python
%endif
find %buildroot -type f -name '*.la' -print -delete
mv %buildroot%_datadir/aclocal/libxml{,2}.m4

%define pkgdocdir %_docdir/%name-%version
mv %buildroot%_defaultdocdir/%name %buildroot%pkgdocdir
install -p -m644 Copyright NEWS README.md %buildroot%pkgdocdir/
rm -rf %buildroot%_defaultdocdir/%name

%files
%_libdir/*.so.*
%dir %pkgdocdir
%pkgdocdir/Copyright
%pkgdocdir/NEWS
%pkgdocdir/README.md

%files -n xml-utils
%_bindir/xmllint
%_bindir/xmlcatalog
%_man1dir/xmllint.*
%_man1dir/xmlcatalog.*

%files devel
%_bindir/*-config
%_libdir/*.so
%_includedir/*
%_pkgconfigdir/*
%_libdir/cmake/*
%_aclocaldir/*
%_man1dir/*-config*

%if_enabled static
%files devel-static
%_libdir/*.a
%endif	#enabled static

%if_with python2
%files -n python-module-%name
%python_sitelibdir/*
%endif

%files -n python3-module-%name
%python3_sitelibdir/*

%files doc
%dir %pkgdocdir
%pkgdocdir/*.html
%pkgdocdir/examples
%pkgdocdir/tutorial
%pkgdocdir/python
%_datadir/gtk-doc/html/libxml2

%changelog
