%{?optflags_lto:%global optflags_lto %optflags_lto -ffat-lto-objects}
%def_disable static
%define origname xview
%define rel %nil
#define rel -18c

Name: lib%origname
Version: 3.2p1.4
Release: alt13

Summary: XView libraries for X11
License: Distributable
Url: http://step.polymtl.ca/~coyote/xview_main.html
# http://physionet.caregroup.harvard.edu/physiotools/xview/
Group: System/Libraries
Packager: Igor Vlasenko <viy@altlinux.ru>

#Source0:	ftp://sunsite.unc.edu/pub/Linux/libs/X/xview/xview-3.2p1.4.src.tar.gz
Source0: %{origname}_%version.orig.tar.gz
# Gentoo
#Source0: %{origname}-%version%rel.tar.gz
# debian
#Patch0: %{origname}_%version-23.diff.gz
# debian
Patch0: xview-3.2p1.4-debian-26.patch
Patch1: %{origname}_%version-alt-xorg7.patch
Patch2: xview_3.2p1.4-alt-gcc41.patch
Patch3: xview_3.2p1.4-alt-sys_errlist.patch

# debian patches
Patch21: olvwm-posix-regex.patch
Patch22: xview-FD_SETSIZE.patch
Patch23: xview-shelltool-manpage-cpp-compatibility.patch
Patch24: xview-sysv-wait-and-signals.patch



Provides: %origname = %version

BuildRequires: gccmakedep imake libXext-devel xorg-cf-files libX11-devel libtirpc-devel

#imake
#set_gcc_version 3.3

%description
XView provides a set of pre-built, user-interface objects such as
canvases, scrollbars, menus, and control panels. The appearance and
functionality of these objects follow the OPEN LOOK Graphical User
Interface (GUI) specification.

This is the Sun implementation of the OpenLook interface standard,
using the xview libraries. While somewhat outdated and superseded by
Motif, or gtk, it is still very useful, especially in providing
compatibility with older installations.

It is possible that the openwin desktop takes up much less disk space
to install and memory to run than modern desktops, which would make it
a good candidate for old hardware.

%package devel
Summary: Header files for XView development
Group: Development/C
Requires: %name = %{?serial:%epoch:}%{version}-%{release}

%description devel
All the files needed to develop applications that, using the XView
libraries, meet the OpenLook interface specifications.

%if_enabled static
%package devel-static
Summary: Static libraries for XView development
Group: Development/C
Requires: %name = %version

%description devel-static
Static libraries for XView development
%endif

%prep
%setup -q -n %origname-%version%rel

%patch0 -p1
%patch1 -p0
%patch2 -p1
%patch3 -p1

# gentoo
# Do not build xgettext and msgfmt since they are provided by the gettext
# package. Using the programs provided by xview breaks many packages
# including vim, grep and binutils.
sed -e 's/MSG_UTIL = xgettext msgfmt/#MSG_UTIL = xgettext msgfmt/' \
	-i util/Imakefile

# gentoo (#120910) Look for imake in the right place
#sed -i -e 's:\/X11::g' imake 
#sed -i -e 's:/usr/X11R6:/usr:' config/XView.cf Build-LinuxXView.bash

#Patch6: xview-3.2-alt-glibc28.patch
#subst s,__linux__,__old_linux__,g lib/libxview/file_chooser/file_list.c

# debian patches
%patch21 -p1
%patch22 -p1
%patch23 -p1
%patch24 -p1

%build
%add_optflags -fcommon
%add_optflags -I/usr/include/tirpc
#add_optflags -DTEST1_tirpc
rm -f make

sed -i 's,-DNO_CAST_VATOAV,-DNO_CAST_VATOAV -I/usr/include/tirpc,' config/XView.cf

export IMAKEINCLUDE="-I"`pwd`"/config -I%_datadir/X11/config"
cd config
imake -DUseInstalled 
cd ..
xmkmf -a
make \
	CC=gcc \
	CCOPTIONS="%optflags"

#export OPENWINHOME="/usr"
#export X11DIR="/usr"
#bash Build-LinuxXView.bash libs 
#bash Build-LinuxXView.bash clients 
#bash Build-LinuxXView.bash contrib
#bash Build-LinuxXView.bash olvwm

%install
install -d %buildroot{%_libdir,%_man7dir,%_includedir}

for name in olgx xview; do
	cp lib/lib$name/lib$name.a %buildroot%_libdir
	cp -d lib/lib$name/lib$name.so.* %buildroot%_libdir
done

install xview.man %buildroot%_mandir/man7/xview.7

for dir in olgx olgx_private xview xview_private pixrect; do
	cp -aL build/include/$dir %buildroot%_includedir
done

ln -sf libolgx.so.3.2.4 %buildroot%_libdir/libolgx.so.3
ln -sf libxview.so.3.2.4 %buildroot%_libdir/libxview.so.3

ln -sf libolgx.so.3.2.4 %buildroot%_libdir/libolgx.so
ln -sf libxview.so.3.2.4 %buildroot%_libdir/libxview.so

%files
%_libdir/libolgx.so.*
%_libdir/libxview.so.*

%files devel
%doc contrib/examples/
%_libdir/libolgx.so
%_libdir/libxview.so
%_man7dir/xview.7.*
%_includedir/olgx
%_includedir/olgx_private
%_includedir/pixrect
%_includedir/xview
%_includedir/xview_private

%if_enabled static
%files lib%origname-devel-static
%_libdir/libolgx.a
%_libdir/libxview.a
%else 
%exclude %_libdir/libolgx.a
%exclude %_libdir/libxview.a
%endif

%changelog
