%define rdn_name net.sourceforge.liferea

Name: liferea
Version: 1.15.9
Release: alt1

Summary: A RSS News Reader for GNOME
License: GPL-2.0-or-later
Group: Networking/News
Url: https://lzone.de/liferea

Obsoletes: %name-gtkhtml < %version-%release %name-xulrunner < %version-%release
Provides: %name-backend = %version-%release %name-gtkhtml = %version-%release %name-xulrunner = %version-%release

Vcs: https://github.com/lwindolf/liferea.git

Source: %name-%version.tar
Patch: %name-%version-%release.patch

Requires: dconf gnome-icon-theme
Requires: typelib(Gtk) = 3.0 libpeas-python3-loader

%add_python3_path %_libdir/%name/plugins
%add_typelib_req_skiplist typelib(AppIndicator3)

BuildRequires(pre): gobject-introspection-devel rpm-build-gir >= 0.7.3-alt3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-pygobject3-devel
BuildRequires: xvfb-run gcc-c++ intltool
BuildRequires: pkgconfig(gtk+-3.0) >= 3.24.0
BuildRequires: pkgconfig(glib-2.0) >= 2.50.0 pkgconfig(gio-2.0) >= 2.50.0 pkgconfig(gmodule-2.0) >= 2.0.0 pkgconfig(gthread-2.0)
BuildRequires: pkgconfig(fribidi)
BuildRequires: pkgconfig(pango) >= 1.4.0
BuildRequires: pkgconfig(libxml-2.0) >= 2.6.27 pkgconfig(libxslt) >= 1.1.19
BuildRequires: pkgconfig(sqlite3) >= 3.7.0
BuildRequires: pkgconfig(libsoup-3.0) >= 3.2 pkgconfig(webkit2gtk-4.1) pkgconfig(json-glib-1.0) pkgconfig(webkit2gtk-web-extension-4.1)
BuildRequires: pkgconfig(gobject-introspection-1.0) gir(Gtk) = 3.0
BuildRequires: pkgconfig(gsettings-desktop-schemas)
BuildRequires: pkgconfig(libpeas-1.0) >= 1.0.0 pkgconfig(libpeas-gtk-1.0) >= 1.0.0

%set_typelibdir %_libdir/%name/girepository-1.0

%description
Liferea is a desktop feed reader/news aggregator that brings together
all of the content from your favorite subscriptions into a simple interface
that makes it easy to organize and browse feeds.
Its GUI is similar to a desktop mail/newsclient, with an embedded graphical browser.

%package plugins-gnome-keyring
Summary: GNOME Keyring Support for the %name
Group: Networking/News
Requires: %name = %EVR

%description plugins-gnome-keyring
Allow Liferea to use GNOME keyring as password store

%prep
%setup
%patch -p1

%build
%autoreconf
%configure \
	--enable-introspection \
	--disable-static
xvfb-run %make_build

%install
%makeinstall_std

%find_lang --with-gnome --with-man %name

%files -f %name.lang
%doc AUTHORS COPYING ChangeLog
%_bindir/*
%_libdir/%name/girepository-1.0/*.typelib
%_datadir/%name/
%_datadir/glib-2.0/schemas/*.xml
%_datadir/GConf/gsettings/%name.convert
%_datadir/metainfo/%rdn_name.appdata.xml
%_desktopdir/%rdn_name.desktop
%_datadir/dbus-1/services/%rdn_name.service
%_datadir/icons/hicolor/*/apps/*
%_man1dir/%name.*
%_libdir/%name/web-extension/*.so
%exclude  %_libdir/%name/web-extension/*.la

%dir %_libdir/%name/plugins
%dir %_libdir/%name/plugins/__pycache__

# plugins. may be separated packages?
%_libdir/%name/plugins/bold-unread.*
%_libdir/%name/plugins/__pycache__/bold-unread.*
%_libdir/%name/plugins/getfocus.*
%_libdir/%name/plugins/__pycache__/getfocus.*
%_libdir/%name/plugins/headerbar.*
%_libdir/%name/plugins/__pycache__/headerbar.*
%_libdir/%name/plugins/libnotify.*
%_libdir/%name/plugins/__pycache__/libnotify.*
%_libdir/%name/plugins/plugin-installer.*
%_libdir/%name/plugins/__pycache__/plugin-installer.*
%_libdir/%name/plugins/trayicon.*
%_libdir/%name/plugins/__pycache__/trayicon.*
%_libdir/%name/plugins/add-bookmark-site*
%_libdir/%name/plugins/__pycache__/add-bookmark-site.*
%_libdir/%name/plugins/download-manager.*
%_libdir/%name/plugins/__pycache__/download-manager.*

%files plugins-gnome-keyring
%_libdir/%name/plugins/gnome-keyring.*
%_libdir/%name/plugins/__pycache__/gnome-keyring.*

%changelog
