%def_disable static

Name: linux-atm
Version: 2.5.1
Release: alt7

Summary: Asynchronous Transfer Mode tools
License: GPLv2
Group: System/Libraries
Url: http://linux-atm.sourceforge.net/


Source: %name-%version-%release.tar

Requires: libatm = %version-%release
BuildRequires: flex, glibc-kernheaders

%description
This package contains tools to support ATM (Asynchronous Transfer Mode)
networking and some types of DSL modems.
ATM (Asynchronous Transfer Mode) networking for Linux is still under
development now but it works quite stable now and has been already
included in 2.4.x series kernels.

%package -n libatm
Summary: ATM (Asynchronous Transfer Mode) support library
License: LGPLv2
Group: System/Libraries
Provides: lib%name = %version-%release
Obsoletes: lib%name

%description -n libatm
This package contains libraries for
support ATM (Asynchronous Transfer Mode)
networking and some types of DSL modems.

%package -n libatm-devel
Summary: ATM development library
License: LGPLv2
Group: Development/C
Requires: libatm = %version-%release
Provides: lib%name-devel = %version-%release
Obsoletes: lib%name-devel

%description -n libatm-devel
This package contains development files needed to compile programs with libatm.

%package -n libatm-devel-static
Summary: ATM static library
License: LGPLv2
Group: Development/C
Requires: libatm-devel = %version-%release
Provides: lib%name-devel-static = %version-%release
Obsoletes: lib%name-devel-static

%description -n libatm-devel-static
This package contains libatm static library.

%prep
%setup

%build
%autoreconf
%configure %{subst_enable static}
make

%install
%makeinstall
bzip2 -9k ChangeLog

%files
%doc AUTHORS BUGS ChangeLog.bz2 NEWS README THANKS
%doc COPYING src/ilmid/COPYRIGHT src/lane/COPYRIGHT.TUT
%config(noreplace) %_sysconfdir/atmsigd.conf
%_bindir/*
%_sbindir/*
%_mandir/man?/*

%files -n libatm
%_libdir/*.so.*

%files -n libatm-devel
%_includedir/*
%_libdir/*.so

%if_enabled static
%files -n libatm-devel-static
%_libdir/*.a
%endif

%changelog
