# Original package name LuaExpat
%define oname luaexpat

Name: lua5.1-module-%oname
Version: 1.5.0
Release: alt1
Epoch: 1

Summary: XML Expat parsing
License: MIT
Group: Development/Other
Url: https://matthewwild.co.uk/projects/luaexpat/

%if "5.1" == "5.3"
Obsoletes: lua-module-%oname < %EVR
Provides: lua-module-%oname = %version
%else
Obsoletes: lua5-%oname < %EVR
Provides: lua5-%oname = %version
Obsoletes: lua-expat < %EVR
Provides: lua-expat = %version
%endif

# repacked https://matthewwild.co.uk/projects/luaexpat/luaexpat-%version.tar.gz
Source: luaexpat-%version.tar

BuildRequires(pre): liblua5.1-devel rpm-build-lua
# Automatically added by buildreq on ...
BuildRequires: lua5.1 libexpat-devel

%description
      LuaExpat is a SAX (Simple API for XML) XML parser based on the
      Expat library.

%prep
%setup -n %oname-%version

%build
%make_build \
	CFLAGS="%optflags -std=c99" \
	LUA_V=5.1 \
	LUA_CDIR=%lua_modulesdir \
	#

%install
%makeinstall_std \
	LUA_V=5.1 \
	LUA_CDIR=%lua_modulesdir \
	#

%files
%lua_modulesdir/lxp.so
%lua_modulesdir_noarch/lxp/lom.lua
%lua_modulesdir_noarch/lxp/threat.lua
%lua_modulesdir_noarch/lxp/totable.lua
%doc README.md

%changelog
