Name: lua5.3-module-luafilesystem
Version: 1.8.0
Release: alt1

Summary: File System Library for the Lua Programming Language
License: MIT/X11
Group: Development/Other
Url: https://keplerproject.github.io/luafilesystem/

%if "%current_lua_version" >= "5.3"
Obsoletes: lua-module-luafilesystem < %version
Provides: lua-module-luafilesystem = %version
%else
Obsoletes: lua5-luafilesystem < %version
Provides: lua5-luafilesystem = %version
%endif

# https://github.com/keplerproject/luafilesystem/archive/v%version.tar.gz
Source: luafilesystem-%version.tar

BuildRequires: lua5.3 liblua5.3-devel

%description
      LuaFileSystem is a Lua library developed to complement the set of
      functions related to file systems offered by the standard Lua
      distribution. LuaFileSystem offers a portable way to access the
      underlying directory structure and file attributes.

%prep
%setup -n luafilesystem-%version

%build
%make_build LUA_LIBDIR=%lua_modulesdir CFLAGS="%optflags"

%install
%makeinstall_std LUA_LIBDIR=%lua_modulesdir

%check
%lua_path_add_buildroot
for t in tests/* ; do
	lua%current_lua_version $t
done

%files
%doc README* doc/*
%lua_modulesdir/*

%changelog
