# Original package name LuaSocket
%define oname luasocket

Epoch: 1
Name: lua5.4-module-%oname
Version: 3.1.0
Release: alt1
Summary: Network support for the Lua language
License: MIT
Group: Development/Other
Url: http://luaforge.net/projects/luasocket/

%if "5.4" >= "5.3"
Obsoletes: lua-module-%oname < %EVR
Provides: lua-module-%oname = %version
%else
Obsoletes: lua5-%oname < %EVR
Provides: lua5-%oname = %version
%endif

Source: %oname-%version.tar
Patch1: lua-module-luasocket-3.0.0-alt-headers.patch

BuildRequires(pre): liblua5.4-devel lua5.4

%description
LuaSocket is a Lua extension library that is composed by two parts: a C core
that provides support for the TCP and UDP transport layers, and a set of Lua
modules that add support for functionality commonly needed by applications that
deal with the Internet.

%package devel
Summary: Headers for %name
Group: Development/Other
Requires: %name

%description devel
This package contains development files for %name.

%prep
%setup -n %oname-%version
%patch1 -p2

%build
%make_build linux \
	LUAV=%lua_version \
	CFLAGS_linux="%optflags -DLUASOCKET_NODEBUG -DLUA_COMPAT_APIINTCASTS" \
	#

%install
make install-unix INSTALL_DATA='install -p -m 644' \
	INSTALL_TOP=%buildroot \
	INSTALL_TOP_CDIR=%buildroot%lua_modulesdir \
	INSTALL_TOP_LDIR=%buildroot%lua_modulesdir_noarch \
	#

# install development files
install -d %buildroot%_includedir/luasocket
install -p -m 0644 src/*.h %buildroot%_includedir/luasocket

%check
subst 's|bin/lua$|bin/lua%current_lua_version|' test/udp-zero-length-send*
%lua_path_add_buildroot
( %lua test/testsrvr.lua ||: )&
sleep 1
%lua test/testclnt.lua

%files
%doc FIX LICENSE* CHANGELOG.md TODO WISH
%lua_modulesdir/*
%lua_modulesdir_noarch/*

%files devel
%_includedir/luasocket

%changelog
